/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import elucent.eidolon.api.capability.IKnowledge;
import elucent.eidolon.api.capability.IReputation;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.network.KnowledgeUpdatePacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.AdvancementTriggers;
import elucent.eidolon.registries.EidolonCapabilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class KnowledgeUtil {
    public static void grantSign(Entity entity, Sign sign) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null || knowledge.knowsSign(sign)) {
            return;
        }
        knowledge.addSign(sign);
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"eidolon.title.new_sign", (Object[])new Object[]{Component.translatable((String)(sign.getRegistryName().getNamespace() + ".sign." + sign.getRegistryName().getPath()))})));
        AdvancementTriggers.triggerSign(sign, player);
        Networking.sendToPlayerClient(new KnowledgeUpdatePacket((Player)player, true), player);
    }

    public static void grantFact(Entity entity, ResourceLocation fact) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null || knowledge.knowsFact(fact)) {
            return;
        }
        knowledge.addFact(fact);
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"eidolon.title.new_fact")));
        Networking.sendToPlayerClient(new KnowledgeUpdatePacket((Player)player, true), player);
        AdvancementTriggers.triggerResearch(fact, player);
    }

    public static void grantResearch(Entity entity, @NotNull Research research) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null || knowledge.knowsResearch(research)) {
            return;
        }
        knowledge.addResearch(research.getRegistryName());
        research.onLearned(player);
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"eidolon.title.new_research", (Object[])new Object[]{String.valueOf(ChatFormatting.GOLD) + research.getName()})));
        Networking.sendToPlayerClient(new KnowledgeUpdatePacket((Player)player, true), player);
        AdvancementTriggers.triggerResearch(research.getRegistryName(), player);
    }

    public static void grantResearchNoToast(Entity entity, @NotNull ResourceLocation research) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null || knowledge.knowsResearch(research)) {
            return;
        }
        knowledge.addResearch(research);
        Networking.sendToPlayerClient(new KnowledgeUpdatePacket((Player)player, true), player);
        AdvancementTriggers.triggerResearch(research, player);
    }

    public static void grantRune(Entity entity, Rune rune) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null || knowledge.knowsRune(rune)) {
            return;
        }
        knowledge.addRune(rune);
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"eidolon.title.new_rune", (Object[])new Object[]{Component.translatable((String)(rune.getRegistryName().getNamespace() + ".rune." + rune.getRegistryName().getPath()))})));
        Networking.sendToPlayerClient(new KnowledgeUpdatePacket((Player)player, true), player);
    }

    public static List<Sign> getKnownSigns(Player player) {
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        return knowledge != null ? new ArrayList<Sign>(knowledge.getKnownSigns()) : Collections.emptyList();
    }

    public static boolean knowsSign(Player player, Sign sign) {
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        return knowledge != null && knowledge.knowsSign(sign);
    }

    public static boolean knowsFact(Player player, ResourceLocation fact) {
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        return knowledge != null && knowledge.knowsFact(fact);
    }

    public static boolean knowsResearch(Player player, ResourceLocation research) {
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        return knowledge != null && knowledge.knowsResearch(research);
    }

    public static boolean knowsRune(Player player, Rune rune) {
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        return knowledge != null && knowledge.knowsRune(rune);
    }

    public static void removeSign(Entity entity, Sign sign) {
        KnowledgeUtil.removeItem(entity, k -> k.knowsSign(sign), k -> k.removeSign(sign));
    }

    public static void removeFact(Entity entity, ResourceLocation fact) {
        KnowledgeUtil.removeItem(entity, k -> k.knowsFact(fact), k -> k.removeFact(fact));
    }

    public static void removeResearch(Entity entity, ResourceLocation research) {
        KnowledgeUtil.removeItem(entity, k -> k.knowsResearch(research), k -> k.removeResearch(research));
    }

    public static void removeRune(Entity entity, Rune rune) {
        KnowledgeUtil.removeItem(entity, k -> k.knowsRune(rune), k -> k.removeRune(rune));
    }

    public static void resetSigns(Entity entity) {
        KnowledgeUtil.resetPart(entity, IKnowledge::resetSigns);
    }

    public static void resetFacts(Entity entity) {
        KnowledgeUtil.resetPart(entity, IKnowledge::resetFacts);
    }

    public static void resetResearch(Entity entity) {
        KnowledgeUtil.resetPart(entity, IKnowledge::resetResearch);
    }

    public static void resetRunes(Entity entity) {
        KnowledgeUtil.resetPart(entity, IKnowledge::resetRunes);
    }

    private static void removeItem(Entity entity, Predicate<IKnowledge> check, Consumer<IKnowledge> removeAction) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null || !check.test(knowledge)) {
            return;
        }
        removeAction.accept(knowledge);
        Networking.sendToPlayerClient(new KnowledgeUpdatePacket((Player)player, true), player);
    }

    private static void resetPart(Entity entity, Consumer<IKnowledge> resetAction) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledge knowledge = (IKnowledge)player.getCapability(EidolonCapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge == null) {
            return;
        }
        resetAction.accept(knowledge);
        Networking.sendToPlayerClient(new KnowledgeUpdatePacket((Player)player, true), player);
    }

    public static void tryFix(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        IReputation devotion = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        if (devotion != null) {
            Deities.getDeities().forEach(deity -> {
                Deity.Stage next;
                double rep = devotion.getReputation(deity.getId());
                Deity.Stage curStage = deity.getProgression().last(rep);
                double fakeRep = 1.0;
                int counter = 0;
                while (fakeRep < (double)curStage.rep() && counter++ < 20 && (next = deity.getProgression().next(fakeRep)) != null) {
                    deity.onReputationLock(player, next.id());
                    deity.onReputationUnlock(player, next.id());
                    fakeRep = next.rep() + 1;
                }
            });
        }
    }
}

