/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.util.TargetMode;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityUtil {
    public static final String THRALL_KEY = "eidolon:thrall";
    private static final Predicate<Entity> FALLBACK_TARGET_PREDICATE = entity -> true;

    public static void enthrall(LivingEntity caster, LivingEntity thrall) {
        thrall.getPersistentData().putUUID(THRALL_KEY, caster.getUUID());
        if (thrall instanceof Mob) {
            Mob mob = (Mob)thrall;
            mob.setPersistenceRequired();
        }
    }

    public static boolean isEnthralled(LivingEntity entity) {
        return entity.getPersistentData().contains(THRALL_KEY);
    }

    public static boolean isEnthralledBy(LivingEntity entity, LivingEntity owner) {
        return entity != null && owner != null && EntityUtil.isEnthralled(entity) && entity.getPersistentData().getUUID(THRALL_KEY).equals(owner.getUUID());
    }

    public static boolean sameMaster(@NotNull LivingEntity entity, @NotNull LivingEntity source) {
        if (!EntityUtil.isEnthralled(entity) || !EntityUtil.isEnthralled(source)) {
            return false;
        }
        return entity.getPersistentData().getUUID(THRALL_KEY).equals(source.getPersistentData().getUUID(THRALL_KEY));
    }

    public static void moveTowardsTarget(Entity entity) {
        Predicate<Entity> targetPredicate;
        Entity owner;
        if (entity == null) {
            return;
        }
        if (entity instanceof Projectile) {
            Predicate<Entity> targetMode;
            Projectile projectile = (Projectile)entity;
            owner = projectile.getOwner();
            if (projectile instanceof TargetMode) {
                TargetMode mode = (TargetMode)projectile;
                v0 = mode.eidolonrepraised$getMode();
            } else {
                v0 = targetMode = null;
            }
            if (entity instanceof SpellProjectileEntity) {
                SpellProjectileEntity spellProjectile = (SpellProjectileEntity)entity;
                targetPredicate = spellProjectile.compulsoryTrackingPredicate.or(targetMode != null ? targetMode : target -> false).and(spellProjectile.trackingPredicate);
            } else {
                targetPredicate = targetMode != null ? targetMode : FALLBACK_TARGET_PREDICATE;
            }
        } else {
            owner = null;
            targetPredicate = FALLBACK_TARGET_PREDICATE;
        }
        List entities = entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(12.0), target -> !(!targetPredicate.test((Entity)target) || target == owner || !target.isAlive() || owner != null && target.isAlliedTo(owner) || entity.level().isClientSide() && target == Minecraft.getInstance().player));
        if (!entities.isEmpty()) {
            LivingEntity nearest = entities.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr(entity))).get();
            Vec3 diff = nearest.position().add(0.0, (double)(nearest.getBbHeight() / 2.0f), 0.0).subtract(entity.position());
            Vec3 newmotion = entity.getDeltaMovement().add(diff.normalize()).scale(0.75);
            entity.setDeltaMovement(newmotion);
        }
    }
}

