/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidolonFakePlayer
extends FakePlayer {
    private static final Connection NETWORK_MANAGER = new Connection(PacketFlow.CLIENTBOUND);
    public static final GameProfile PROFILE = new GameProfile(UUID.fromString("edaa2c36-64e2-11ee-8c99-0242ac120002"), "Eidolon");
    private static WeakReference<EidolonFakePlayer> FAKE_PLAYER = null;

    private EidolonFakePlayer(ServerLevel world) {
        super(world, PROFILE);
        this.connection = new FakePlayNetHandler(world.getServer(), (ServerPlayer)this, CommonListenerCookie.createInitial((GameProfile)PROFILE, (boolean)false));
    }

    public static EidolonFakePlayer getPlayer(ServerLevel world) {
        EidolonFakePlayer ret;
        EidolonFakePlayer eidolonFakePlayer = ret = FAKE_PLAYER != null ? (EidolonFakePlayer)((Object)FAKE_PLAYER.get()) : null;
        if (ret == null) {
            ret = new EidolonFakePlayer(world);
            FAKE_PLAYER = new WeakReference<EidolonFakePlayer>(ret);
        }
        ret.setLevel((Level)world);
        return (EidolonFakePlayer)((Object)FAKE_PLAYER.get());
    }

    @NotNull
    public OptionalInt openMenu(MenuProvider container) {
        return OptionalInt.empty();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Eidolon_Fake_Player");
    }

    private static class FakePlayNetHandler
    extends ServerGamePacketListenerImpl {
        public FakePlayNetHandler(MinecraftServer server, ServerPlayer playerIn, CommonListenerCookie pCookie) {
            super(server, NETWORK_MANAGER, playerIn, pCookie);
        }

        public void send(@NotNull Packet<?> packetIn) {
        }

        public void send(@NotNull Packet<?> p_243227_, @Nullable PacketSendListener p_243273_) {
        }
    }
}

