/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.registries.Registry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Worldgen {
    public static final TagKey<Structure> CATACOMBS = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"catacombs"));
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"eidolon");
    static final ResourceKey<PlacedFeature> LEAD_ORE_GEN = Worldgen.registerPlacedKey("lead_ore_placed");
    static final ResourceKey<PlacedFeature> SILVER_ORE_GEN = Worldgen.registerPlacedKey("silver_ore_placed");
    static final ResourceKey<PlacedFeature> ILLWOOD_CHECKED = Worldgen.registerPlacedKey("illwood_checked");
    static final ResourceKey<PlacedFeature> ILLWOOD_PLACED = Worldgen.registerPlacedKey("illwood_placed");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE_CFG = Worldgen.registerConfKey("lead_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE_CFG = Worldgen.registerConfKey("silver_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ILLWOOD_TREE_CFG = Worldgen.registerConfKey("illwood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ILLWOOD_SPAWN = Worldgen.registerConfKey("illwood_spawn");

    public static ResourceKey<Feature<?>> registerFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)name));
    }

    public static ResourceKey<PlacedFeature> registerPlacedKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)name));
    }

    public static void bootstrapConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest ruletest1 = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest ruletest2 = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        HolderGetter placed = context.lookup(Registries.PLACED_FEATURE);
        context.register(LEAD_ORE_CFG, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)ruletest1, (BlockState)((Block)Registry.LEAD_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)ruletest2, (BlockState)((Block)Registry.DEEP_LEAD_ORE.get()).defaultBlockState())), 6)));
        context.register(SILVER_ORE_CFG, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)ruletest1, (BlockState)((Block)Registry.SILVER_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)ruletest2, (BlockState)((Block)Registry.DEEP_SILVER_ORE.get()).defaultBlockState())), 6)));
        context.register(ILLWOOD_TREE_CFG, (Object)new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)Registry.ILLWOOD_LOG.get())), (TrunkPlacer)new DarkOakTrunkPlacer(5, 1, 3), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)Registry.ILLWOOD_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build()));
        context.register(ILLWOOD_SPAWN, (Object)new ConfiguredFeature(Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{placed.getOrThrow(ILLWOOD_CHECKED)}))));
    }

    public static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(LEAD_ORE_GEN, (Object)new PlacedFeature((Holder)configured.get(LEAD_ORE_CFG).get(), Worldgen.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-47), (VerticalAnchor)VerticalAnchor.absolute((int)41)))));
        context.register(SILVER_ORE_GEN, (Object)new PlacedFeature((Holder)configured.get(SILVER_ORE_CFG).get(), Worldgen.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-60), (VerticalAnchor)VerticalAnchor.absolute((int)33)))));
        context.register(ILLWOOD_CHECKED, (Object)new PlacedFeature((Holder)configured.get(ILLWOOD_TREE_CFG).get(), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)Registry.ILLWOOD_SAPLING.get())))));
        context.register(ILLWOOD_PLACED, (Object)new PlacedFeature((Holder)configured.get(ILLWOOD_SPAWN).get(), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.01f, (int)0))));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.spread(), p_195348_, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return Worldgen.orePlacement((PlacementModifier)CountPlacement.of((int)p_195344_), p_195345_);
    }

    public static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return Worldgen.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)p_195350_), p_195351_);
    }
}

