/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.SignSequence;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.spell.AnimalSacrificeSpell;
import elucent.eidolon.common.spell.ConvertZombieSpell;
import elucent.eidolon.common.spell.DarkTouchSpell;
import elucent.eidolon.common.spell.FireTouchSpell;
import elucent.eidolon.common.spell.FrostSpell;
import elucent.eidolon.common.spell.HealSpell;
import elucent.eidolon.common.spell.LightArmorSpell;
import elucent.eidolon.common.spell.LightSpell;
import elucent.eidolon.common.spell.LightTouchSpell;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.spell.SmiteSpell;
import elucent.eidolon.common.spell.SunderArmorSpell;
import elucent.eidolon.common.spell.ThrallSpell;
import elucent.eidolon.common.spell.UndeadLureSpell;
import elucent.eidolon.common.spell.VillagerSacrificeSpell;
import elucent.eidolon.common.spell.WaterSpell;
import elucent.eidolon.common.spell.ZombifySpell;
import elucent.eidolon.recipe.ChantRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Signs;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Spells {
    static final List<Spell> spells = new CopyOnWriteArrayList<Spell>();
    static final Map<ResourceLocation, Spell> spellMap = new ConcurrentHashMap<ResourceLocation, Spell>();
    public static Spell DARK_PRAYER;
    public static Spell DARKLIGHT_CHANT;
    public static Spell DARK_ANIMAL_SACRIFICE;
    public static Spell DARK_TOUCH;
    public static Spell FROST_CHANT;
    public static Spell DARK_VILLAGER_SACRIFICE;
    public static Spell ZOMBIFY;
    public static Spell ENTHRALL_UNDEAD;
    public static Spell LIGHT_PRAYER;
    public static Spell FIRE_CHANT;
    public static Spell LIGHT_CHANT;
    public static Spell HOLY_TOUCH;
    public static Spell LAY_ON_HANDS;
    public static Spell CURE_ZOMBIE_CHANT;
    public static Spell SMITE_CHANT;
    public static Spell SUNDER_ARMOR;
    public static Spell BLESS_ARMOR;
    public static Spell WATER_CHANT;
    public static Spell UNDEAD_LURE;
    public static PrayerSpell CENSER;

    public static Spell find(ResourceLocation loc) {
        return spellMap.getOrDefault(loc, null);
    }

    public static Spell find(SignSequence signs, Level world) {
        for (Spell spell : spells) {
            if (!spell.matches(signs)) continue;
            return spell;
        }
        for (RecipeHolder chantRecipeH : world.getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.CHANT_TYPE.get())) {
            ChantRecipe chantRecipe = (ChantRecipe)chantRecipeH.value();
            if (!chantRecipe.matches(signs)) continue;
            Spell spell = chantRecipe.getChant();
            spell.setSigns(signs);
            spells.add(spell);
            return spell;
        }
        return null;
    }

    public static Spell registerWithFallback(Spell spell) {
        Spells.register(spell);
        spells.add(spell);
        return spell;
    }

    public static Spell register(Spell spell) {
        ModConfigSpec spec;
        spellMap.put(spell.getRegistryName(), spell);
        ModConfigSpec.Builder spellBuilder = new ModConfigSpec.Builder();
        spell.buildConfig(spellBuilder);
        spell.CONFIG = spec = spellBuilder.build();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec, spell.getRegistryName().getNamespace() + "/" + spell.getRegistryName().getPath() + ".toml");
        return spell;
    }

    public static List<Spell> getSpells() {
        return spells;
    }

    public static Map<ResourceLocation, Spell> getSpellMap() {
        return spellMap;
    }

    public static void init() {
        DARK_PRAYER = Spells.register(new PrayerSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"dark_prayer"), Deities.DARK_DEITY, Signs.WICKED_SIGN, Signs.WICKED_SIGN, Signs.WICKED_SIGN));
        DARKLIGHT_CHANT = Spells.register(new LightSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"darklight_chant"), Deities.DARK_DEITY, Signs.WICKED_SIGN, Signs.FLAME_SIGN, Signs.WICKED_SIGN, Signs.FLAME_SIGN));
        DARK_ANIMAL_SACRIFICE = Spells.register(new AnimalSacrificeSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"dark_animal_sacrifice"), Deities.DARK_DEITY, 3, 0.5, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.WICKED_SIGN));
        DARK_TOUCH = Spells.register(new DarkTouchSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"dark_touch"), Signs.WICKED_SIGN, Signs.SOUL_SIGN, Signs.WICKED_SIGN, Signs.SOUL_SIGN));
        FROST_CHANT = Spells.register(new FrostSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"frost_touch"), Signs.WICKED_SIGN, Signs.WINTER_SIGN, Signs.BLOOD_SIGN, Signs.WINTER_SIGN, Signs.WICKED_SIGN));
        DARK_VILLAGER_SACRIFICE = Spells.register(new VillagerSacrificeSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"dark_villager_sacrifice"), Deities.DARK_DEITY, 6, 1.0, Signs.BLOOD_SIGN, Signs.WICKED_SIGN, Signs.BLOOD_SIGN, Signs.SOUL_SIGN));
        ZOMBIFY = Spells.register(new ZombifySpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"zombify_villager"), 8, 1.25, Signs.DEATH_SIGN, Signs.BLOOD_SIGN, Signs.WICKED_SIGN, Signs.DEATH_SIGN, Signs.SOUL_SIGN, Signs.BLOOD_SIGN));
        ENTHRALL_UNDEAD = Spells.register(new ThrallSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"enthrall_spell"), Signs.WICKED_SIGN, Signs.MIND_SIGN, Signs.MAGIC_SIGN, Signs.MAGIC_SIGN, Signs.MIND_SIGN));
        LIGHT_PRAYER = Spells.register(new PrayerSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"light_prayer"), Deities.LIGHT_DEITY, Signs.SACRED_SIGN, Signs.SACRED_SIGN, Signs.SACRED_SIGN));
        FIRE_CHANT = Spells.register(new FireTouchSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"fire_chant"), Signs.FLAME_SIGN, Signs.FLAME_SIGN, Signs.FLAME_SIGN));
        LIGHT_CHANT = Spells.register(new LightSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"light_chant"), Deities.LIGHT_DEITY, Signs.SACRED_SIGN, Signs.FLAME_SIGN, Signs.SACRED_SIGN, Signs.FLAME_SIGN));
        HOLY_TOUCH = Spells.register(new LightTouchSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"holy_touch"), Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN, Signs.SOUL_SIGN));
        LAY_ON_HANDS = Spells.register(new HealSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"lay_on_hands"), Signs.FLAME_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.SACRED_SIGN));
        CURE_ZOMBIE_CHANT = Spells.register(new ConvertZombieSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"cure_zombie"), 8, 1.25, Signs.SACRED_SIGN, Signs.SOUL_SIGN, Signs.MIND_SIGN, Signs.HARMONY_SIGN, Signs.FLAME_SIGN, Signs.SOUL_SIGN));
        SMITE_CHANT = Spells.register(new SmiteSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"smite_chant"), Signs.FLAME_SIGN, Signs.MAGIC_SIGN, Signs.SACRED_SIGN, Signs.DEATH_SIGN, Signs.MAGIC_SIGN, Signs.SACRED_SIGN));
        SUNDER_ARMOR = Spells.register(new SunderArmorSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"sunder_armor"), Signs.FLAME_SIGN, Signs.MAGIC_SIGN, Signs.WICKED_SIGN, Signs.MAGIC_SIGN, Signs.FLAME_SIGN));
        BLESS_ARMOR = Spells.register(new LightArmorSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"reinforce_armor"), Signs.SACRED_SIGN, Signs.WARDING_SIGN, Signs.SACRED_SIGN, Signs.WARDING_SIGN, Signs.SACRED_SIGN));
        WATER_CHANT = Spells.register(new WaterSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"create_water"), Signs.WINTER_SIGN, Signs.WINTER_SIGN, Signs.FLAME_SIGN, Signs.FLAME_SIGN));
        UNDEAD_LURE = Spells.register(new UndeadLureSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"undead_lure"), Signs.MIND_SIGN, Signs.MAGIC_SIGN, Signs.WICKED_SIGN));
        CENSER = (PrayerSpell)Spells.register(new PrayerSpell(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"basic_incense"), Deities.LIGHT_DEITY, new Sign[0]));
    }
}

