/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.research.ResearchTask;
import elucent.eidolon.datagen.EidItemTagProvider;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Signs;
import elucent.eidolon.util.KnowledgeUtil;
import elucent.eidolon.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class Researches {
    static final Map<ResourceLocation, Research> researches = new HashMap<ResourceLocation, Research>();
    static final Multimap<ResourceLocation, Research> blockResearches = HashMultimap.create();
    static final Multimap<ResourceLocation, Research> entityResearches = HashMultimap.create();
    static final List<Function<Random, ResearchTask>> taskPool = new ArrayList<Function<Random, ResearchTask>>();
    public static Research FIRE_SPELL;
    public static Research FROST_SPELL;

    public static Research register(Research r, Object ... sources) {
        researches.put(r.getRegistryName(), r);
        for (Object o : sources) {
            if (o instanceof Block) {
                Block b = (Block)o;
                blockResearches.put((Object)RegistryUtil.getRegistryName(b), (Object)r);
                continue;
            }
            if (!(o instanceof EntityType)) continue;
            EntityType e = (EntityType)o;
            entityResearches.put((Object)RegistryUtil.getRegistryName(e), (Object)r);
        }
        return r;
    }

    public static void addTask(Function<Random, ResearchTask> task) {
        taskPool.add(task);
    }

    @NotNull
    public static Collection<Research> getBlockResearches(Block b) {
        return blockResearches.get((Object)RegistryUtil.getRegistryName(b));
    }

    @NotNull
    public static Collection<Research> getEntityResearches(Entity e) {
        return entityResearches.get((Object)RegistryUtil.getRegistryName(e.getType()));
    }

    public static Collection<Research> getResearches() {
        return researches.values();
    }

    @Nullable
    public static Research find(ResourceLocation location) {
        return researches.getOrDefault(location, null);
    }

    public static ResearchTask getRandomTask(Random random) {
        return taskPool.get(random.nextInt(taskPool.size())).apply(random);
    }

    public static void init() {
        Researches.addTask(ResearchTask.TaskItems.fromTag(EidItemTagProvider.SCRIBE_ITEMS, 3));
        Researches.addTask(ResearchTask.TaskItems.fromTag(EidItemTagProvider.SCRIBE_ITEMS, 3));
        Researches.addTask(ResearchTask.TaskItems.fromTag(EidItemTagProvider.SCRIBE_ITEMS, 3));
        Researches.addTask(ResearchTask.XP::new);
        Researches.addTask(ResearchTask.XP::new);
        Researches.register(new Research(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"gluttony"), 3), EntityType.PIG);
        FIRE_SPELL = Researches.register(new Research(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"flames"), 5){

            @Override
            public void onLearned(ServerPlayer serverPlayer) {
                KnowledgeUtil.grantSign((Entity)serverPlayer, Signs.FLAME_SIGN);
            }
        }.addSpecialTasks(5, new ResearchTask.TaskItems(new ItemStack((ItemLike)Items.BLAZE_ROD, 3)), new ResearchTask.TaskItems(new ItemStack((ItemLike)Items.FIRE_CHARGE, 3)), new ResearchTask.XP(6)), EntityType.BLAZE);
        FROST_SPELL = Researches.register(new Research(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"frost"), 5){

            @Override
            public void onLearned(ServerPlayer serverPlayer) {
                KnowledgeUtil.grantSign((Entity)serverPlayer, Signs.WINTER_SIGN);
            }
        }.addSpecialTasks(4, new ResearchTask.TaskItems(new ItemStack((ItemLike)Items.ICE, 10)), new ResearchTask.TaskItems(new ItemStack((ItemLike)Items.SNOW, 10)), new ResearchTask.XP(6)).addSpecialTasks(5, new ResearchTask.TaskItems(new ItemStack((ItemLike)Registry.WRAITH_HEART.get(), 3))), EntityType.STRAY, EidolonEntities.WRAITH.get());
    }
}

