/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.api.altar.AltarEntry;
import elucent.eidolon.api.altar.AltarKeys;
import elucent.eidolon.registries.Registry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class AltarEntries {
    static final Map<Block, AltarEntry> entries = new HashMap<Block, AltarEntry>();

    public static AltarEntry find(Block block) {
        return entries.getOrDefault(block, null);
    }

    public static AltarEntry find(Item blockItem) {
        return entries.getOrDefault(Block.byItem((Item)blockItem), null);
    }

    public static void init() {
        entries.put(Blocks.TORCH, new AltarEntry(AltarKeys.LIGHT_KEY).setPower(1.0));
        entries.put(Blocks.SOUL_TORCH, new AltarEntry(AltarKeys.LIGHT_KEY).setPower(1.0));
        entries.put(Blocks.LANTERN, new AltarEntry(AltarKeys.LIGHT_KEY).setPower(1.0).setCapacity(1.0));
        entries.put((Block)Registry.CANDLE.get(), new AltarEntry(AltarKeys.LIGHT_KEY).setPower(2.0));
        entries.put((Block)Registry.CANDLESTICK.get(), new AltarEntry(AltarKeys.LIGHT_KEY).setPower(2.0));
        entries.put((Block)Registry.MAGIC_CANDLE.get(), new AltarEntry(AltarKeys.LIGHT_KEY).setPower(2.0));
        entries.put((Block)Registry.MAGIC_CANDLESTICK.get(), new AltarEntry(AltarKeys.LIGHT_KEY).setPower(3.0));
        entries.put(Blocks.SKELETON_SKULL, new AltarEntry(AltarKeys.SKULL_KEY).setCapacity(2.0));
        entries.put(Blocks.ZOMBIE_HEAD, new AltarEntry(AltarKeys.SKULL_KEY).setCapacity(1.0).setPower(1.0));
        entries.put(Blocks.WITHER_SKELETON_SKULL, new AltarEntry(AltarKeys.SKULL_KEY).setCapacity(3.0).setPower(1.0));
        entries.put(Blocks.POTTED_WARPED_ROOTS, new AltarEntry(AltarKeys.PLANT_KEY).setPower(1.0));
        entries.put(Blocks.POTTED_CRIMSON_ROOTS, new AltarEntry(AltarKeys.PLANT_KEY).setPower(1.0));
        entries.put(Blocks.POTTED_WARPED_FUNGUS, new AltarEntry(AltarKeys.PLANT_KEY).setPower(2.0));
        entries.put(Blocks.POTTED_CRIMSON_FUNGUS, new AltarEntry(AltarKeys.PLANT_KEY).setPower(2.0));
        entries.put(Blocks.POTTED_WITHER_ROSE, new AltarEntry(AltarKeys.PLANT_KEY).setPower(3.0));
        entries.put((Block)Registry.GOBLET.get(), new AltarEntry(AltarKeys.OFFERS_KEY).setCapacity(2.0));
        entries.put((Block)Registry.CENSER.get(), new AltarEntry(AltarKeys.OFFERS_KEY).setCapacity(2.0));
    }
}

