/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.api.spells.Sign;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AdvancementTriggers {
    public static final DeferredRegister<CriterionTrigger<?>> TRIGGERS = DeferredRegister.create((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)"eidolon");
    static final HashMap<ResourceLocation, CriterionTrigger<?>> triggers = new HashMap();
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> WICKED = AdvancementTriggers.register("wicked_path");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> SACRED = AdvancementTriggers.register("sacred_path");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> SACRIFICE = AdvancementTriggers.register("sacrifice");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> INCENSE = AdvancementTriggers.register("incense");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> VSACRIFICE = AdvancementTriggers.register("villager_sacrifice");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> LAY_ON_HANDS = AdvancementTriggers.register("lay_on_hands");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> ZOMBIFY = AdvancementTriggers.register("zombify");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> CURE_ZOMBIE = AdvancementTriggers.register("cure_zombie");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> ENTHRALL = AdvancementTriggers.register("enthrall_undead");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> SMITE = AdvancementTriggers.register("smite_undead");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> FLAME = AdvancementTriggers.register("flame_spell");
    public static final DeferredHolder<CriterionTrigger<?>, PlayerTrigger> FROST = AdvancementTriggers.register("frost_spell");

    public static Criterion<?> createCriterion(DeferredHolder<CriterionTrigger<?>, PlayerTrigger> holder) {
        return ((PlayerTrigger)holder.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()));
    }

    public static void rewardNearbyPlayers(PlayerTrigger criteria, ServerLevel level, BlockPos pos, int radius) {
        AABB aabb = new AABB(pos).inflate((double)radius);
        for (ServerPlayer player : level.players()) {
            if (!aabb.contains(player.getX(), player.getY(), player.getZ())) continue;
            criteria.trigger(player);
        }
    }

    public static <T extends CriterionTrigger<?>> DeferredHolder<CriterionTrigger<?>, PlayerTrigger> register(String pName) {
        return AdvancementTriggers.register(pName, new PlayerTrigger());
    }

    public static <T extends CriterionTrigger<?>> DeferredHolder<CriterionTrigger<?>, T> register(String pName, T pTrigger) {
        return TRIGGERS.register(pName, () -> pTrigger);
    }

    public static <T extends CriterionTrigger<?>> T register(T trigger, ResourceLocation id) {
        CriterionTrigger cTrigger = CriteriaTriggers.register((String)id.toString(), trigger);
        triggers.put(id, cTrigger);
        return (T)cTrigger;
    }

    public static void triggerSign(Sign sign, ServerPlayer player) {
        switch (sign.getRegistryName().toString()) {
            case "eidolon:wicked": {
                ((PlayerTrigger)WICKED.get()).trigger(player);
                break;
            }
            case "eidolon:sacred": {
                ((PlayerTrigger)SACRED.get()).trigger(player);
            }
        }
    }

    public static void triggerResearch(ResourceLocation research, ServerPlayer player) {
        CriterionTrigger<?> trigger = triggers.get(research);
        if (trigger instanceof PlayerTrigger) {
            PlayerTrigger playerTrigger = (PlayerTrigger)trigger;
            playerTrigger.trigger(player);
        } else {
            switch (research.toString()) {
                case "eidolon:frost": {
                    ((PlayerTrigger)FROST.get()).trigger(player);
                    break;
                }
                case "eidolon:flames": {
                    ((PlayerTrigger)FLAME.get()).trigger(player);
                    break;
                }
                case "eidolon:sacrifice_mob": {
                    ((PlayerTrigger)SACRIFICE.get()).trigger(player);
                    break;
                }
                case "eidolon:basic_incense": {
                    ((PlayerTrigger)INCENSE.get()).trigger(player);
                    break;
                }
                case "eidolon:sacrifice_villager": {
                    ((PlayerTrigger)VSACRIFICE.get()).trigger(player);
                    break;
                }
                case "eidolon:heal_villager": {
                    ((PlayerTrigger)LAY_ON_HANDS.get()).trigger(player);
                    break;
                }
                case "eidolon:zombify_villager": {
                    ((PlayerTrigger)ZOMBIFY.get()).trigger(player);
                    break;
                }
                case "eidolon:cure_zombie": {
                    ((PlayerTrigger)CURE_ZOMBIE.get()).trigger(player);
                    break;
                }
                case "eidolon:enthrall_undead": {
                    ((PlayerTrigger)ENTHRALL.get()).trigger(player);
                    break;
                }
                case "eidolon:smite_undead": {
                    ((PlayerTrigger)SMITE.get()).trigger(player);
                }
            }
        }
    }
}

