/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.SummonRitual;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class SummonRitualRecipe
extends RitualRecipe {
    ResourceLocation entity;
    int count = 1;

    public SummonRitualRecipe(ResourceLocation result, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, int count, float healthRequirement) {
        super(reagent, pedestalItems, focusItems, healthRequirement);
        this.entity = result;
        this.count = count;
    }

    public SummonRitualRecipe(ResourceLocation result, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems) {
        super(reagent, pedestalItems, focusItems);
        this.entity = result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.SUMMON_RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.SUMMON_RITUAL_TYPE.get();
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)this.entity.getNamespace(), (String)("summon_" + this.entity.getPath()));
    }

    @Override
    public Ritual getRitual() {
        return new SummonRitual((EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.entity), this.count).setRegistryName(this.getId());
    }

    public ResourceLocation getEntityRL() {
        return this.entity;
    }

    public int getCount() {
        return this.count;
    }

    public static class Serializer
    extends RitualRecipe.Serializer<SummonRitualRecipe> {
        public static final MapCodec<SummonRitualRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("output").forGetter(r -> r.entity), (App)Ingredient.CODEC.fieldOf("reagent").forGetter(r -> r.reagent), (App)Ingredient.CODEC.listOf().fieldOf("pedestal_items").forGetter(r -> r.pedestalItems), (App)Ingredient.CODEC.listOf().fieldOf("focus_items").forGetter(r -> r.focusItems), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(r -> r.count), (App)Codec.FLOAT.optionalFieldOf("healthRequirement", (Object)Float.valueOf(0.0f)).forGetter(r -> Float.valueOf(r.healthRequirement))).apply((Applicative)instance, SummonRitualRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SummonRitualRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SummonRitualRecipe::getEntityRL, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RitualRecipe::getReagent, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getPedestalItems, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getFocusItems, (StreamCodec)ByteBufCodecs.INT, SummonRitualRecipe::getCount, (StreamCodec)ByteBufCodecs.FLOAT, RitualRecipe::getHealthRequirement, SummonRitualRecipe::new);

        @NotNull
        public MapCodec<SummonRitualRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SummonRitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

