/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import elucent.eidolon.api.ritual.FocusItemRequirement;
import elucent.eidolon.api.ritual.HealthRequirement;
import elucent.eidolon.api.ritual.ItemRequirement;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.tile.BrazierTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

public abstract class RitualRecipe
implements Recipe<BrazierTileEntity> {
    public Ingredient reagent;
    public List<Ingredient> pedestalItems;
    public List<Ingredient> focusItems;
    public List<Ingredient> invariantItems = new ArrayList<Ingredient>(2);
    float healthRequirement = 0.0f;

    public List<Ingredient> getFocusItems() {
        return this.focusItems;
    }

    public List<Ingredient> getInvariantItems() {
        return this.invariantItems;
    }

    public List<Ingredient> getPedestalItems() {
        return this.pedestalItems;
    }

    public Ingredient getReagent() {
        return this.reagent;
    }

    public float getHealthRequirement() {
        return this.healthRequirement;
    }

    public RitualRecipe(Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, List<Ingredient> invariantItems, float healthRequirement) {
        this(reagent, pedestalItems, focusItems, healthRequirement);
        this.invariantItems = invariantItems;
    }

    public RitualRecipe(Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems) {
        this.reagent = reagent;
        this.pedestalItems = pedestalItems;
        this.focusItems = focusItems;
    }

    public RitualRecipe(Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, float healthRequirement) {
        this(reagent, pedestalItems, focusItems);
        this.healthRequirement = healthRequirement;
    }

    public RitualRecipe() {
        this.reagent = Ingredient.EMPTY;
        this.pedestalItems = new ArrayList<Ingredient>();
        this.focusItems = new ArrayList<Ingredient>();
    }

    public boolean excludeJei() {
        return false;
    }

    public boolean isMatch(List<ItemStack> pedestalItems, List<ItemStack> focusItems, ItemStack reagent) {
        return this.doesReagentMatch(reagent) && this.pedestalItems.size() == pedestalItems.size() && RitualRecipe.doItemsMatch(pedestalItems, this.pedestalItems) && this.focusItems.size() == focusItems.size() && RitualRecipe.doItemsMatch(focusItems, this.focusItems);
    }

    public boolean doesReagentMatch(ItemStack reag) {
        return this.reagent.test(reag);
    }

    public static boolean doItemsMatch(List<ItemStack> inputs, List<Ingredient> recipeItems) {
        StackedContents recipeitemhelper = new StackedContents();
        for (ItemStack i : inputs) {
            recipeitemhelper.accountStack(i, 1);
        }
        return inputs.size() == recipeItems.size() && RecipeMatcher.findMatches(inputs, recipeItems) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RitualRecipe that = (RitualRecipe)o;
        return Objects.equals(this.reagent, that.reagent) && Objects.equals(this.pedestalItems, that.pedestalItems) && Objects.equals(this.focusItems, that.focusItems);
    }

    public int hashCode() {
        return Objects.hash(this.reagent, this.pedestalItems, this.focusItems);
    }

    public String toString() {
        return "RitualBrazierRecipe{catalyst=" + String.valueOf(this.reagent) + ", pedestalItems=" + String.valueOf(this.pedestalItems) + ", focusItems=" + String.valueOf(this.focusItems) + "}";
    }

    public abstract Ritual getRitual();

    public Ritual getRitualWithRequirements() {
        Ritual ritual = this.getRitual().clone().addRequirements(this.pedestalItems.stream().map(ItemRequirement::new).collect(Collectors.toList()));
        if (!this.focusItems.isEmpty()) {
            ritual.addRequirements(this.focusItems.stream().map(FocusItemRequirement::new).collect(Collectors.toList()));
        }
        if (this.healthRequirement > 0.0f) {
            ritual.addRequirement(new HealthRequirement(this.healthRequirement));
        }
        ritual.sortRequirements();
        return ritual;
    }

    public boolean matches(@NotNull BrazierTileEntity tile, @NotNull Level worldIn) {
        ArrayList<ItemStack> pedestalItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> focusItems = new ArrayList<ItemStack>();
        tile.providePedestalItems(pedestalItems, focusItems);
        return this.isMatch(pedestalItems, focusItems, tile.getStack());
    }

    @NotNull
    public ItemStack assemble(@NotNull BrazierTileEntity inv, @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider access) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public abstract ResourceLocation getId();

    public static abstract class Serializer<T extends RitualRecipe>
    implements RecipeSerializer<T> {
    }
}

