/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.CraftingRitual;
import elucent.eidolon.common.tile.BrazierTileEntity;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.util.RegistryUtil;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class ItemRitualRecipe
extends RitualRecipe {
    public ItemStack result;
    public boolean keepNbtOfReagent = false;
    public ResourceLocation symbol;
    public int color;

    public boolean keepsComponent() {
        return this.keepNbtOfReagent;
    }

    public ItemRitualRecipe(Ingredient reagent, List<Ingredient> stacks, List<Ingredient> foci, ItemStack output, boolean keepNbtOfReagent, float healthRequirement) {
        super(reagent, stacks, foci, healthRequirement);
        this.result = output;
        this.keepNbtOfReagent = keepNbtOfReagent;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull BrazierTileEntity inv, @NotNull HolderLookup.Provider registryAccess) {
        ItemStack result = this.result.copy();
        if (this.keepNbtOfReagent && !inv.getStack().isComponentsPatchEmpty()) {
            result.applyComponents(inv.getStack().getComponentsPatch());
            result.setDamageValue(0);
        }
        return result.copy();
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider access) {
        return this.result == null ? ItemStack.EMPTY : this.result.copy();
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public Ritual getRitual() {
        return (this.symbol != null && this.color != 0 ? new CraftingRitual(this.symbol, this.color, this.result, this.keepNbtOfReagent) : new CraftingRitual.SanguineRitual(this.result)).setRegistryName(this.getId());
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        ResourceLocation itemId = RegistryUtil.getRegistryName(this.result.getItem());
        if (this.symbol != null && this.color != 0) {
            return ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("sanguine_" + itemId.getPath()));
        }
        return ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("brazier_craft_" + itemId.getPath()));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.CRAFTING_RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.CRAFTING_RITUAL_TYPE.get();
    }

    public static class SerializerCrafting
    extends RitualRecipe.Serializer<ItemRitualRecipe> {
        public static final MapCodec<ItemRitualRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("reagent").forGetter(RitualRecipe::getReagent), (App)Ingredient.CODEC.listOf().fieldOf("pedestal_items").forGetter(RitualRecipe::getPedestalItems), (App)Ingredient.CODEC.listOf().fieldOf("focus_items").forGetter(RitualRecipe::getFocusItems), (App)ItemStack.CODEC.fieldOf("result").forGetter(ItemRitualRecipe::getResult), (App)Codec.BOOL.optionalFieldOf("keep_nbt_of_reagent", (Object)false).forGetter(ItemRitualRecipe::keepsComponent), (App)Codec.FLOAT.optionalFieldOf("health_requirement", (Object)Float.valueOf(0.0f)).forGetter(RitualRecipe::getHealthRequirement)).apply((Applicative)instance, ItemRitualRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemRitualRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RitualRecipe::getReagent, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getPedestalItems, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getFocusItems, (StreamCodec)ItemStack.STREAM_CODEC, ItemRitualRecipe::getResult, (StreamCodec)ByteBufCodecs.BOOL, ItemRitualRecipe::keepsComponent, (StreamCodec)ByteBufCodecs.FLOAT, RitualRecipe::getHealthRequirement, ItemRitualRecipe::new);

        @NotNull
        public MapCodec<ItemRitualRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ItemRitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

