/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.util.RegistryUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class DyeRecipe
extends ShapelessRecipe {
    public DyeRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_266797_) {
        ItemStack output = super.assemble(inv, p_266797_);
        if (!output.isEmpty()) {
            ItemStack ingredient;
            int i;
            for (i = 0; i < inv.size(); ++i) {
                ingredient = inv.getItem(i);
                if (ingredient.isEmpty() || !ingredient.is(output.getItem())) continue;
                output.applyComponents(ingredient.getComponentsPatch());
            }
            for (i = 0; i < inv.size(); ++i) {
                ingredient = inv.getItem(i);
                DyeColor color = DyeColor.getColor((ItemStack)ingredient);
                if (ingredient.isEmpty() || color == null) continue;
                output.set(DataComponents.BASE_COLOR, (Object)color);
            }
        }
        return output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.DYE_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.DYE_TYPE.get();
    }

    public static JsonElement asRecipe(Item item) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:dye");
        JsonArray ingredients = new JsonArray();
        JsonObject dyeObject = new JsonObject();
        dyeObject.addProperty("tag", Tags.Items.DYES.location().toString());
        ingredients.add((JsonElement)dyeObject);
        JsonObject input = new JsonObject();
        input.addProperty("item", RegistryUtil.getRegistryName(item).toString());
        ingredients.add((JsonElement)input);
        jsonobject.add("ingredients", (JsonElement)ingredients);
        JsonObject itemObject = new JsonObject();
        itemObject.addProperty("item", RegistryUtil.getRegistryName(item).toString());
        jsonobject.add("result", (JsonElement)itemObject);
        return jsonobject;
    }
}

