/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.ExecCommandRitual;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Signs;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class CommandRitualRecipe
extends RitualRecipe {
    List<String> commands;
    ResourceLocation symbol = Signs.HARMONY_SIGN.sprite();
    int color = 0;

    private CommandRitualRecipe setSymbol(ResourceLocation symbol) {
        this.symbol = symbol;
        return this;
    }

    private CommandRitualRecipe setColor(int color) {
        this.color = color;
        return this;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public CommandRitualRecipe(List<String> commands, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, float healthRequirement) {
        super(reagent, pedestalItems, focusItems, healthRequirement);
        this.commands = commands;
    }

    @Override
    public Ritual getRitual() {
        return new ExecCommandRitual(this.symbol, this.color, this.commands).setRegistryName(this.getId());
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)("ritual_exec_command_" + this.commands.hashCode()));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.COMMAND_RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.COMMAND_RITUAL_TYPE.get();
    }

    public static class Serializer
    extends RitualRecipe.Serializer<CommandRitualRecipe> {
        public static final MapCodec<CommandRitualRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("commands").forGetter(CommandRitualRecipe::getCommands), (App)Ingredient.CODEC.fieldOf("reagent").forGetter(RitualRecipe::getReagent), (App)Ingredient.CODEC.listOf().fieldOf("pedestal_items").forGetter(RitualRecipe::getPedestalItems), (App)Ingredient.CODEC.listOf().fieldOf("focus_items").forGetter(RitualRecipe::getFocusItems), (App)Codec.FLOAT.fieldOf("health_requirement").orElse((Object)Float.valueOf(0.0f)).forGetter(RitualRecipe::getHealthRequirement)).apply((Applicative)instance, CommandRitualRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CommandRitualRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), CommandRitualRecipe::getCommands, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RitualRecipe::getReagent, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getPedestalItems, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getFocusItems, (StreamCodec)ByteBufCodecs.FLOAT, RitualRecipe::getHealthRequirement, CommandRitualRecipe::new);

        @NotNull
        public MapCodec<CommandRitualRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CommandRitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

