/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.capability.WingsDataImpl;
import elucent.eidolon.network.AbstractPacket;
import elucent.eidolon.registries.EidolonCapabilities;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WingsDataUpdatePacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<WingsDataUpdatePacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("wings_data_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WingsDataUpdatePacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, pkt -> pkt.uuid, (StreamCodec)ByteBufCodecs.VAR_LONG, pkt -> pkt.lastFlapTime, (StreamCodec)ByteBufCodecs.INT, pkt -> pkt.dashTicks, (StreamCodec)ByteBufCodecs.BOOL, pkt -> pkt.isFlying, WingsDataUpdatePacket::new);
    final UUID uuid;
    long lastFlapTime;
    int dashTicks;
    boolean isFlying;

    public WingsDataUpdatePacket(Player player) {
        this.uuid = player.getUUID();
        WingsDataImpl wingsData = (WingsDataImpl)player.getCapability(EidolonCapabilities.WINGS_CAPABILITY);
        if (wingsData != null) {
            this.lastFlapTime = wingsData.getLastFlapTime(player);
            this.dashTicks = wingsData.getDashTicks(player);
            this.isFlying = wingsData.isFlying(player);
        }
    }

    public WingsDataUpdatePacket(UUID uuid, long lastFlapTime, int dashTicks, boolean isFlying) {
        this.uuid = uuid;
        this.lastFlapTime = lastFlapTime;
        this.dashTicks = dashTicks;
        this.isFlying = isFlying;
    }

    public static void encode(WingsDataUpdatePacket object, FriendlyByteBuf buffer) {
        buffer.writeUUID(object.uuid);
        buffer.writeLong(object.lastFlapTime);
        buffer.writeInt(object.dashTicks);
        buffer.writeBoolean(object.isFlying);
    }

    public static WingsDataUpdatePacket decode(FriendlyByteBuf buffer) {
        return new WingsDataUpdatePacket(buffer.readUUID(), buffer.readLong(), buffer.readInt(), buffer.readBoolean());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        WingsDataImpl wingsData;
        if (player.getUUID().equals(this.uuid) && (wingsData = (WingsDataImpl)player.getCapability(EidolonCapabilities.WINGS_CAPABILITY)) != null) {
            if (this.isFlying && !wingsData.isFlying(player)) {
                wingsData.startFlying(player);
            } else if (!this.isFlying && wingsData.isFlying(player)) {
                wingsData.stopFlying(player);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

