/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.network.AbstractPacket;
import elucent.eidolon.network.AttemptCastPacket;
import elucent.eidolon.network.ChilledEffectPacket;
import elucent.eidolon.network.CrucibleFailPacket;
import elucent.eidolon.network.CrucibleSuccessPacket;
import elucent.eidolon.network.CrystallizeEffectPacket;
import elucent.eidolon.network.DeathbringerSlashEffectPacket;
import elucent.eidolon.network.ExtinguishEffectPacket;
import elucent.eidolon.network.FeatherEffectPacket;
import elucent.eidolon.network.FlameEffectPacket;
import elucent.eidolon.network.GenericParticlePacket;
import elucent.eidolon.network.IgniteEffectPacket;
import elucent.eidolon.network.InitCodexPacket;
import elucent.eidolon.network.InscribePacket;
import elucent.eidolon.network.KnowledgeUpdatePacket;
import elucent.eidolon.network.LifestealEffectPacket;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.OpenCodexPacket;
import elucent.eidolon.network.ResearchActionPacket;
import elucent.eidolon.network.RitualCompletePacket;
import elucent.eidolon.network.RitualConsumePacket;
import elucent.eidolon.network.SoulUpdatePacket;
import elucent.eidolon.network.SpellCastPacket;
import elucent.eidolon.network.TESyncPacket;
import elucent.eidolon.network.WingsDashPacket;
import elucent.eidolon.network.WingsDataUpdatePacket;
import elucent.eidolon.network.WingsFlapPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class Networking {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar("eidolon");
        reg.playToClient(GenericParticlePacket.TYPE, GenericParticlePacket.CODEC, Networking::handle);
        reg.playToClient(ChilledEffectPacket.TYPE, ChilledEffectPacket.CODEC, Networking::handle);
        reg.playToClient(TESyncPacket.TYPE, TESyncPacket.CODEC, Networking::handle);
        reg.playToClient(ExtinguishEffectPacket.TYPE, ExtinguishEffectPacket.CODEC, Networking::handle);
        reg.playToClient(IgniteEffectPacket.TYPE, IgniteEffectPacket.CODEC, Networking::handle);
        reg.playToClient(FlameEffectPacket.TYPE, FlameEffectPacket.CODEC, Networking::handle);
        reg.playToClient(RitualCompletePacket.TYPE, RitualCompletePacket.CODEC, Networking::handle);
        reg.playToClient(RitualConsumePacket.TYPE, RitualConsumePacket.CODEC, Networking::handle);
        reg.playToClient(CrystallizeEffectPacket.TYPE, CrystallizeEffectPacket.CODEC, Networking::handle);
        reg.playToClient(CrucibleFailPacket.TYPE, CrucibleFailPacket.CODEC, Networking::handle);
        reg.playToClient(CrucibleSuccessPacket.TYPE, CrucibleSuccessPacket.CODEC, Networking::handle);
        reg.playToClient(LifestealEffectPacket.TYPE, LifestealEffectPacket.CODEC, Networking::handle);
        reg.playToClient(MagicBurstEffectPacket.TYPE, MagicBurstEffectPacket.CODEC, Networking::handle);
        reg.playToClient(KnowledgeUpdatePacket.TYPE, KnowledgeUpdatePacket.CODEC, Networking::handle);
        reg.playToServer(AttemptCastPacket.TYPE, AttemptCastPacket.CODEC, Networking::handle);
        reg.playToClient(SpellCastPacket.TYPE, SpellCastPacket.CODEC, Networking::handle);
        reg.playToClient(ResearchActionPacket.TYPE, ResearchActionPacket.CODEC, Networking::handle);
        reg.playToClient(DeathbringerSlashEffectPacket.TYPE, DeathbringerSlashEffectPacket.CODEC, Networking::handle);
        reg.playToClient(SoulUpdatePacket.TYPE, SoulUpdatePacket.CODEC, Networking::handle);
        reg.playToServer(WingsFlapPacket.TYPE, WingsFlapPacket.CODEC, Networking::handle);
        reg.playToServer(WingsDashPacket.TYPE, WingsDashPacket.CODEC, Networking::handle);
        reg.playToClient(WingsDataUpdatePacket.TYPE, WingsDataUpdatePacket.CODEC, Networking::handle);
        reg.playToClient(FeatherEffectPacket.TYPE, FeatherEffectPacket.CODEC, Networking::handle);
        reg.playToClient(OpenCodexPacket.TYPE, OpenCodexPacket.CODEC, Networking::handle);
        reg.playBidirectional(InitCodexPacket.TYPE, InitCodexPacket.CODEC, Networking::handle);
        reg.playToClient(InscribePacket.TYPE, InscribePacket.CODEC, Networking::handle);
    }

    public static <T extends AbstractPacket> void handle(T message, IPayloadContext ctx) {
        if (ctx.flow().getReceptionSide() == LogicalSide.SERVER) {
            Networking.handleServer(message, ctx);
        } else {
            ClientMessageHandler.handleClient(message, ctx);
        }
    }

    private static <T extends AbstractPacket> void handleServer(T message, IPayloadContext ctx) {
        MinecraftServer server = ctx.player().getServer();
        message.onServerReceived(server, (ServerPlayer)ctx.player());
    }

    public static void sendToNearbyClient(Level world, BlockPos pos, CustomPacketPayload toSend) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)ws, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)toSend, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToNearbyClient(Level world, Entity e, CustomPacketPayload toSend) {
        Networking.sendToNearbyClient(world, e.blockPosition(), toSend);
    }

    public static void sendToPlayerClient(CustomPacketPayload msg, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload msg) {
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static class ClientMessageHandler {
        private ClientMessageHandler() {
        }

        public static <T extends AbstractPacket> void handleClient(T message, IPayloadContext ctx) {
            Minecraft minecraft = Minecraft.getInstance();
            message.onClientReceived(minecraft, (Player)minecraft.player);
        }
    }
}

