/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.network.AbstractPacket;
import elucent.eidolon.registries.EidolonParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FlameEffectPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<FlameEffectPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("flame_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlameEffectPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, pkt -> pkt.pos, (StreamCodec)ByteBufCodecs.FLOAT, pkt -> Float.valueOf(pkt.r), (StreamCodec)ByteBufCodecs.FLOAT, pkt -> Float.valueOf(pkt.g), (StreamCodec)ByteBufCodecs.FLOAT, pkt -> Float.valueOf(pkt.b), FlameEffectPacket::new);
    final BlockPos pos;
    final float r;
    final float g;
    final float b;

    public FlameEffectPacket(BlockPos pos, float r, float g, float b) {
        this.pos = pos;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level world = player.level();
        BlockPos pos = this.pos;
        double x = (double)pos.getX() + 0.5;
        double y = pos.getY() + 1;
        double z = (double)pos.getZ() + 0.5;
        world.playSound(Eidolon.proxy.getPlayer(), x, y, z, SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 1.0f, 0.75f);
        Particles.create((ParticleType)EidolonParticles.FLAME_PARTICLE.get()).setAlpha(0.75f, 0.0f).setScale(0.5f, 0.25f).setLifetime(40).randomOffset(0.5, 0.125).randomVelocity(0.003125f, 0.009375f).addVelocity(0.0, 0.003125f, 0.0).setColor(this.r, this.g, this.b, this.r, this.g * 0.5f, this.b * 1.5f).repeat(world, x, y, z, 10);
        Particles.create((ParticleType)EidolonParticles.SPARKLE_PARTICLE.get()).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(80).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.125).addVelocity(0.0, 0.25, 0.0).setColor(this.r, this.g * 1.5f, this.b * 2.0f, this.r, this.g, this.b).enableGravity().setSpin(0.4f).repeat(world, x, y, z, world.random.nextInt(4) + 3);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

