/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.network.AbstractPacket;
import elucent.eidolon.registries.EidolonParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrystallizeEffectPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<CrystallizeEffectPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("crystallize_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrystallizeEffectPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, pkt -> pkt.pos, CrystallizeEffectPacket::new);
    final BlockPos pos;

    public CrystallizeEffectPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(CrystallizeEffectPacket object, FriendlyByteBuf buffer) {
        buffer.writeBlockPos(object.pos);
    }

    public static CrystallizeEffectPacket decode(FriendlyByteBuf buffer) {
        return new CrystallizeEffectPacket(buffer.readBlockPos());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level world = player.level();
        BlockPos pos = this.pos;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.1;
        double z = (double)pos.getZ() + 0.5;
        float r = 0.96862745f;
        float g = 0.6117647f;
        float b = 0.8627451f;
        Particles.create((ParticleType)EidolonParticles.SPARKLE_PARTICLE.get()).setAlpha(1.0f, 0.0f).setScale(0.25f, 0.0f).setLifetime(20).randomOffset(0.5, 0.0).randomVelocity(0.0, 0.375).addVelocity(0.0, 0.125, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).setSpin(0.4f).repeat(world, x, y, z, 20);
    }

    @NotNull
    public CustomPacketPayload.Type<CrystallizeEffectPacket> type() {
        return TYPE;
    }
}

