/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.common.entity.ChantCasterEntity;
import elucent.eidolon.network.AbstractPacket;
import elucent.eidolon.registries.Signs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AttemptCastPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<AttemptCastPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("attempt_cast"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttemptCastPacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, pkt -> pkt.uuid, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), pkt -> pkt.runes.stream().map(sign -> sign.getRegistryName().toString()).toList(), (uuid, runeNames) -> {
        ArrayList<Sign> runes = new ArrayList<Sign>();
        for (String name : runeNames) {
            runes.add(Signs.find(ResourceLocation.parse((String)name)));
        }
        return new AttemptCastPacket((UUID)uuid, (List<Sign>)runes);
    });
    final List<Sign> runes = new ArrayList<Sign>();
    final UUID uuid;

    public AttemptCastPacket(Player player, List<Sign> runes) {
        this.runes.addAll(runes);
        this.uuid = player.getUUID();
    }

    public AttemptCastPacket(UUID uuid, List<Sign> runes) {
        this.runes.addAll(runes);
        this.uuid = uuid;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Level world = player.level();
        if (player.getUUID().equals(this.uuid)) {
            ChantCasterEntity.createChanter((Player)player, world, this.runes);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

