/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui.jei;

import elucent.eidolon.api.ritual.FocusItemPresentRequirement;
import elucent.eidolon.api.ritual.HealthRequirement;
import elucent.eidolon.api.ritual.IRequirement;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.codex.RitualPage;
import elucent.eidolon.gui.jei.JEIRegistry;
import elucent.eidolon.recipe.ItemRitualRecipe;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RitualCategory
implements IRecipeCategory<RitualRecipe> {
    static final ResourceLocation UUID = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"ritual");
    private final IDrawable background;
    private final IDrawable icon;

    public RitualCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/gui/jei_page_bg.png"), 0, 0, 138, 172);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Registry.BRAZIER.get()));
    }

    @NotNull
    public RecipeType<RitualRecipe> getRecipeType() {
        return JEIRegistry.RITUAL_CATEGORY;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)I18n.get((String)"jei.eidolon.ritual", (Object[])new Object[0]));
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder layout, @NotNull RitualRecipe recipe, @NotNull IFocusGroup ingredients) {
        ArrayList<RitualPage.RitualIngredient> inputs = new ArrayList<RitualPage.RitualIngredient>();
        RitualPage.rearrangeIngredients(recipe, inputs);
        float angleStep = Math.min(30, 180 / inputs.size());
        double rootAngle = 90.0f - (float)(inputs.size() - 1) * angleStep / 2.0f;
        for (int i = 0; i < inputs.size(); ++i) {
            double a = Math.toRadians(rootAngle + (double)(angleStep * (float)i));
            int dx = (int)(69.0 + 48.0 * Math.cos(a));
            int dy = (int)(91.0 + 48.0 * Math.sin(a));
            layout.addSlot(RecipeIngredientRole.INPUT, dx - 8, dy - 8).addIngredients(((RitualPage.RitualIngredient)inputs.get((int)i)).stack);
        }
        layout.addSlot(RecipeIngredientRole.INPUT, 60, 85).addIngredients(recipe.reagent);
        for (IRequirement iRequirement : recipe.getRitual().getInvariants()) {
            if (!(iRequirement instanceof FocusItemPresentRequirement)) continue;
            FocusItemPresentRequirement focusItemPresentRequirement = (FocusItemPresentRequirement)iRequirement;
            layout.addSlot(RecipeIngredientRole.CATALYST, 91, 82).addIngredients(focusItemPresentRequirement.getMatch());
            break;
        }
        if (recipe instanceof ItemRitualRecipe) {
            ItemRitualRecipe resultRitual = (ItemRitualRecipe)recipe;
            layout.addSlot(RecipeIngredientRole.OUTPUT, 62, 45).addItemStack(resultRitual.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
        }
    }

    public void draw(@NotNull RitualRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ResourceLocation bg = RitualPage.BACKGROUND;
        int x = 5;
        int y = 4;
        guiGraphics.blit(bg, x, y, 0, 0, 128, 160);
        ArrayList<RitualPage.RitualIngredient> inputs = new ArrayList<RitualPage.RitualIngredient>();
        RitualPage.rearrangeIngredients(recipe, inputs);
        Ritual ritual = recipe.getRitualWithRequirements();
        Component name = ritual.getName();
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, name, x + 69 - font.width((FormattedText)name) / 2, y + 5, 0, false);
        float angleStep = Math.min(30, 180 / inputs.size());
        double rootAngle = 90.0f - (float)(inputs.size() - 1) * angleStep / 2.0f;
        for (int i = 0; i < inputs.size(); ++i) {
            double a = Math.toRadians(rootAngle + (double)(angleStep * (float)i));
            int dx = (int)(64.0 + 48.0 * Math.cos(a));
            int dy = (int)(88.0 + 48.0 * Math.sin(a));
            if (((RitualPage.RitualIngredient)inputs.get((int)i)).isFocus) {
                guiGraphics.blit(bg, x + dx - 13, y + dy - 13, 128, 0, 26, 24);
                continue;
            }
            guiGraphics.blit(bg, x + dx - 8, y + dy - 8, 154, 0, 16, 16);
        }
        for (IRequirement iRequirement : ritual.getInvariants()) {
            if (!(iRequirement instanceof FocusItemPresentRequirement)) continue;
            guiGraphics.blit(bg, x + 86 - 5, y + 80 - 5, 128, 0, 26, 24);
            break;
        }
        ritual.getRequirements().stream().filter(HealthRequirement.class::isInstance).map(HealthRequirement.class::cast).findFirst().ifPresent(healthRequirement -> guiGraphics.drawString(font, (Component)Component.translatable((String)"eidolon.jei.health_sacrifice", (Object[])new Object[]{Float.valueOf(healthRequirement.getHealth() / 2.0f)}), x + 8, y + 150, 0xFF0000, false));
        RitualPage.renderRitualSymbol(guiGraphics, x, y, ritual);
    }
}

