/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui.jei;

import elucent.eidolon.Eidolon;
import elucent.eidolon.common.tile.BrazierTileEntity;
import elucent.eidolon.gui.jei.CrucibleCategory;
import elucent.eidolon.gui.jei.DyeRecipeCategory;
import elucent.eidolon.gui.jei.RitualCategory;
import elucent.eidolon.gui.jei.WorktableCategory;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.recipe.DyeRecipe;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.recipe.WorktableRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Registry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIRegistry
implements IModPlugin {
    public static final RecipeType<CrucibleRecipe> CRUCIBLE_CATEGORY = RecipeType.create((String)"eidolon", (String)"crucible", CrucibleRecipe.class);
    public static final RecipeType<WorktableRecipe> WORKTABLE_CATEGORY = RecipeType.create((String)"eidolon", (String)"worktable", WorktableRecipe.class);
    public static final RecipeType<RitualRecipe> RITUAL_CATEGORY = RecipeType.create((String)"eidolon", (String)"rituals", RitualRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registry.CRUCIBLE.get()), new RecipeType[]{CRUCIBLE_CATEGORY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registry.WORKTABLE.get()), new RecipeType[]{WORKTABLE_CATEGORY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Registry.BRAZIER.get()), new RecipeType[]{RITUAL_CATEGORY});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleCategory(guiHelper), new WorktableCategory(guiHelper), new RitualCategory(guiHelper)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        RecipeManager manager = Eidolon.proxy.getWorld().getRecipeManager();
        registry.addRecipes(CRUCIBLE_CATEGORY, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)EidolonRecipes.CRUCIBLE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(WORKTABLE_CATEGORY, manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)EidolonRecipes.WORKTABLE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(RITUAL_CATEGORY, BrazierTileEntity.getRitualRecipes(Eidolon.proxy.getWorld()));
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(DyeRecipe.class, (ICraftingCategoryExtension)new DyeRecipeCategory(null));
    }
}

