/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui.jei;

import elucent.eidolon.codex.CruciblePage;
import elucent.eidolon.codex.Page;
import elucent.eidolon.gui.jei.JEIRegistry;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CrucibleCategory
implements IRecipeCategory<CrucibleRecipe> {
    static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"crucible");
    private final IDrawable background;
    private final IDrawable icon;

    public CrucibleCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/gui/jei_page_bg.png"), 0, 0, 138, 172);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Registry.CRUCIBLE.get()));
    }

    @NotNull
    public RecipeType<CrucibleRecipe> getRecipeType() {
        return JEIRegistry.CRUCIBLE_CATEGORY;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.eidolon.crucible");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public static void condense(List<StackIngredient> stacks) {
        Iterator<StackIngredient> iter = stacks.iterator();
        StackIngredient last = new StackIngredient(ItemStack.EMPTY, Ingredient.EMPTY);
        while (iter.hasNext()) {
            StackIngredient i = iter.next();
            if (!ItemStack.isSameItem((ItemStack)i.stack, (ItemStack)last.stack) || !ItemStack.isSameItemSameComponents((ItemStack)i.stack, (ItemStack)last.stack) || last.stack.getCount() + i.stack.getCount() > last.stack.getMaxStackSize()) {
                last = i;
                continue;
            }
            last.stack.grow(i.stack.getCount());
            iter.remove();
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder layout, CrucibleRecipe recipe, @NotNull IFocusGroup focusGroup) {
        List<CrucibleRecipe.Step> steps = recipe.getSteps();
        int h = steps.size() * 20 + 32;
        int yoff = 80 - h / 2;
        for (int i = 0; i < steps.size(); ++i) {
            int tx = 4;
            int ty = 3 + yoff + i * 20;
            tx += 24;
            ArrayList<StackIngredient> stepInputs = new ArrayList<StackIngredient>();
            for (Ingredient o : steps.get(i).matches()) {
                ItemStack stack = o.getItems().length > 0 ? o.getItems()[0].copy() : ItemStack.EMPTY.copy();
                if (stack.isEmpty()) continue;
                stepInputs.add(new StackIngredient(stack, o));
            }
            CrucibleCategory.condense(stepInputs);
            for (StackIngredient stepInput : stepInputs) {
                List<ItemStack> inputs = Arrays.stream(stepInput.ingredient.getItems()).map(ItemStack::copy).toList();
                inputs.forEach(ii -> ii.setCount(stepInput.stack.getCount()));
                layout.addSlot(RecipeIngredientRole.INPUT, tx, ty).addItemStacks(inputs);
                tx += 17;
            }
        }
        layout.addSlot(RecipeIngredientRole.OUTPUT, 60, yoff + steps.size() * 20 + 14).addItemStack(recipe.getResultItem());
    }

    public void draw(CrucibleRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int ty;
        List<CrucibleRecipe.Step> steps = recipe.getSteps();
        int h = steps.size() * 20 + 32;
        int yoff = 80 - h / 2;
        int x = 4;
        int y = 5;
        for (int i = 0; i < steps.size(); ++i) {
            int tx = x;
            ty = y + yoff + i * 20;
            guiGraphics.blit(CruciblePage.BACKGROUND, tx, ty, 128, 0, 128, 20);
            tx += 24;
            ArrayList<StackIngredient> stepInputs = new ArrayList<StackIngredient>();
            for (Ingredient o : steps.get(i).matches()) {
                ItemStack stack = o.getItems().length > 0 ? o.getItems()[0].copy() : ItemStack.EMPTY.copy();
                if (stack.isEmpty()) continue;
                stepInputs.add(new StackIngredient(stack, o));
            }
            CrucibleCategory.condense(stepInputs);
            for (StackIngredient counter : stepInputs) {
                if (counter.stack.isEmpty()) continue;
                guiGraphics.blit(CruciblePage.BACKGROUND, tx, ty + 1, 176, 32, 16, 17);
                tx += 17;
            }
            for (int j = 0; j < steps.get(i).stirs(); ++j) {
                guiGraphics.blit(CruciblePage.BACKGROUND, tx, ty + 1, 192, 32, 16, 17);
                tx += 17;
            }
        }
        guiGraphics.blit(CruciblePage.BACKGROUND, x, y + yoff + steps.size() * 20, 128, 64, 128, 32);
        Font font = Minecraft.getInstance().font;
        for (int i = 0; i < steps.size(); ++i) {
            ty = y + yoff + i * 20;
            String string = I18n.get((String)("enchantment.level." + (i + 1)), (Object[])new Object[0]) + ".";
            Objects.requireNonNull(font);
            Page.drawText(guiGraphics, string, x + 7, ty + 17 - 9);
        }
    }

    public static class StackIngredient {
        final ItemStack stack;
        final Ingredient ingredient;

        public StackIngredient(ItemStack stack, Ingredient ingredient) {
            this.stack = stack;
            this.ingredient = ingredient;
        }
    }
}

