/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui;

import elucent.eidolon.gui.WorktableResultSlot;
import elucent.eidolon.recipe.WorktableRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Registry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class WorktableContainer
extends AbstractContainerMenu {
    final CraftingContainer core = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    final CraftingContainer extras = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
    final ResultContainer result = new ResultContainer();
    final Player player;
    final ContainerLevelAccess callable;

    public WorktableContainer(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.NULL);
    }

    public WorktableContainer(int id, Inventory inventory, ContainerLevelAccess callable) {
        super((MenuType)Registry.WORKTABLE_CONTAINER.get(), id);
        this.player = inventory.player;
        this.callable = callable;
        this.addSlot(new WorktableResultSlot(inventory.player, this.core, this.extras, (Container)this.result, 0, 163, 58));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.core, j + i * 3, 40 + j * 18, 40 + i * 18));
            }
        }
        this.addSlot(new Slot((Container)this.extras, 0, 58, 18));
        this.addSlot(new Slot((Container)this.extras, 1, 98, 58));
        this.addSlot(new Slot((Container)this.extras, 2, 58, 98));
        this.addSlot(new Slot((Container)this.extras, 3, 18, 58));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)inventory, i1 + k * 9 + 9, 16 + i1 * 18, 142 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)inventory, l, 16 + l * 18, 200));
        }
    }

    protected void updateCraftingResult(int id, Level world, Player player, CraftingContainer inventory, ResultContainer inventoryResult) {
        if (!world.isClientSide && player instanceof ServerPlayer) {
            RecipeHolder icraftingrecipe;
            Optional optional;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            List worktableRecipeOptional = world.getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.WORKTABLE_TYPE.get());
            if (!this.extras.isEmpty()) {
                for (RecipeHolder worktableRecipe : worktableRecipeOptional) {
                    if (!((WorktableRecipe)worktableRecipe.value()).matches((Container)this.core, (Container)this.extras)) continue;
                    itemstack = ((WorktableRecipe)worktableRecipe.value()).getResult();
                    break;
                }
            }
            if (itemstack.isEmpty() && (optional = world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)inventory.asCraftInput(), world)).isPresent() && inventoryResult.setRecipeUsed(world, serverPlayer, icraftingrecipe = (RecipeHolder)optional.get())) {
                itemstack = ((CraftingRecipe)icraftingrecipe.value()).assemble((RecipeInput)inventory.asCraftInput(), (HolderLookup.Provider)world.registryAccess());
            }
            inventoryResult.setItem(0, itemstack);
            serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(id, this.incrementStateId(), 0, itemstack));
        }
    }

    public void slotsChanged(@NotNull Container inventoryIn) {
        this.callable.execute((p_217069_1_, p_217069_2_) -> this.updateCraftingResult(this.containerId, (Level)p_217069_1_, this.player, this.core, this.result));
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        this.callable.execute((p_217068_2_, p_217068_3_) -> {
            this.clearContainer(playerIn, (Container)this.core);
            this.clearContainer(playerIn, (Container)this.extras);
        });
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return WorktableContainer.stillValid((ContainerLevelAccess)this.callable, (Player)playerIn, (Block)((Block)Registry.WORKTABLE.get()));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                this.callable.execute((p_217067_2_, p_217067_3_) -> itemstack1.getItem().onCraftedBy(itemstack1, p_217067_2_, playerIn));
                if (!this.moveItemStackTo(itemstack1, 14, 50, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index >= 14 && index < 50 ? !this.moveItemStackTo(itemstack1, 1, 14, false) && (index < 41 ? !this.moveItemStackTo(itemstack1, 41, 50, false) : !this.moveItemStackTo(itemstack1, 14, 41, false)) : !this.moveItemStackTo(itemstack1, 14, 50, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSize() {
        return 14;
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, Slot slotIn) {
        return slotIn.container != this.result && super.canTakeItemForPickAll(stack, slotIn);
    }

    public int getOutputSlot() {
        return 0;
    }
}

