/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui;

import com.google.common.collect.Lists;
import elucent.eidolon.Config;
import elucent.eidolon.datagen.EidEnchantmentTagProvider;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class SoulEnchanterContainer
extends AbstractContainerMenu {
    private static final String SOUL_ENCHANT_USES_TAG = "soul_enchant_uses";
    private final Container tableInventory = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            SoulEnchanterContainer.this.slotsChanged((Container)this);
        }
    };
    private final ContainerLevelAccess worldPosCallable;
    private final RandomSource rand = RandomSource.create();
    private final DataSlot xpSeed = DataSlot.standalone();
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] worldClue = new int[]{-1, -1, -1};

    public SoulEnchanterContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.NULL);
    }

    public SoulEnchanterContainer(int id, Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)Registry.SOUL_ENCHANTER_CONTAINER.get(), id);
        this.worldPosCallable = worldPosCallable;
        this.addSlot(new Slot(this, this.tableInventory, 0, 15, 47){

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.tableInventory, 1, 35, 47){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return stack.getItem() == Registry.SOUL_SHARD.get();
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlot(this.xpSeed).set(playerInventory.player.getEnchantmentSeed());
        this.addDataSlot(DataSlot.shared((int[])this.enchantClue, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.enchantClue, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.enchantClue, (int)2));
        this.addDataSlot(DataSlot.shared((int[])this.worldClue, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.worldClue, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.worldClue, (int)2));
    }

    public void slotsChanged(@NotNull Container inventoryIn) {
        if (inventoryIn == this.tableInventory) {
            ItemStack itemstack = inventoryIn.getItem(0);
            this.worldPosCallable.execute((world, pos) -> {
                if (this.isValidItem(itemstack, (HolderLookup.RegistryLookup<Enchantment>)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT))) {
                    IdMap idmap = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    this.rand.setSeed((long)this.xpSeed.get());
                    for (int i1 = 0; i1 < 3; ++i1) {
                        this.enchantClue[i1] = -1;
                        this.worldClue[i1] = -1;
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentInstance> list = this.getEnchantmentList(world.registryAccess(), itemstack, j1);
                        if (list.isEmpty()) continue;
                        EnchantmentInstance enchantmentinstance = list.get(this.rand.nextInt(list.size()));
                        this.enchantClue[j1] = idmap.getId((Object)enchantmentinstance.enchantment);
                        this.worldClue[j1] = enchantmentinstance.level;
                    }
                    this.broadcastChanges();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.enchantClue[i] = -1;
                        this.worldClue[i] = -1;
                    }
                }
            });
        }
    }

    private boolean isValidItem(ItemStack itemStack, HolderLookup.RegistryLookup<Enchantment> tHolderLookup) {
        return !itemStack.isEmpty() && this.canSoulEnchant(itemStack) && this.hasValidEnchantmentAmount(itemStack, tHolderLookup) && (itemStack.isEnchantable() || itemStack.isEnchanted() || itemStack.getItem() == Items.ENCHANTED_BOOK);
    }

    private boolean hasValidEnchantmentAmount(ItemStack itemStack, HolderLookup.RegistryLookup<Enchantment> tHolderLookup) {
        if ((Integer)Config.SOUL_ENCHANTER_MAXIMUM_ENCHANTMENTS.get() < 0) {
            return true;
        }
        return itemStack.getAllEnchantments(tHolderLookup).size() <= (Integer)Config.SOUL_ENCHANTER_MAXIMUM_ENCHANTMENTS.get();
    }

    private void incrementSoulEnchant(ItemStack enchantedItem) {
        if ((Integer)Config.SOUL_ENCHANTER_MAXIMUM_USES.get() < 0) {
            return;
        }
    }

    private boolean canSoulEnchant(ItemStack itemstack) {
        if ((Integer)Config.SOUL_ENCHANTER_MAXIMUM_USES.get() < 0) {
            return true;
        }
        return true;
    }

    public boolean clickMenuButton(@NotNull Player playerIn, int id) {
        ItemStack itemstack = this.tableInventory.getItem(0);
        if (!this.isValidItem(itemstack, (HolderLookup.RegistryLookup<Enchantment>)playerIn.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT))) {
            return false;
        }
        ItemStack soulShards = this.tableInventory.getItem(1);
        int i = id + 1;
        int experienceLevelCost = Math.min(5, this.worldClue[id]);
        if ((soulShards.isEmpty() || soulShards.getCount() < 1) && !playerIn.getAbilities().instabuild) {
            return false;
        }
        if (itemstack.isEmpty() || playerIn.experienceLevel < experienceLevelCost && !playerIn.getAbilities().instabuild) {
            return false;
        }
        this.worldPosCallable.execute((p_217003_6_, p_217003_7_) -> {
            ItemStack itemstack2 = itemstack;
            RegistryAccess registryAccess = p_217003_6_.registryAccess();
            List<EnchantmentInstance> list = this.getEnchantmentList(registryAccess, itemstack, id);
            if (!list.isEmpty()) {
                playerIn.onEnchantmentPerformed(itemstack, experienceLevelCost);
                itemstack2 = itemstack.getItem().applyEnchantments(itemstack, list);
                this.tableInventory.setItem(0, itemstack2);
                CommonHooks.onPlayerEnchantItem((Player)playerIn, (ItemStack)itemstack2, list);
                if (!playerIn.getAbilities().instabuild) {
                    this.incrementSoulEnchant(itemstack2);
                    soulShards.shrink(1);
                    if (soulShards.isEmpty()) {
                        this.tableInventory.setItem(1, ItemStack.EMPTY);
                    }
                }
                playerIn.awardStat(Stats.ENCHANT_ITEM);
                if (playerIn instanceof ServerPlayer) {
                    CriteriaTriggers.ENCHANTED_ITEM.trigger((ServerPlayer)playerIn, itemstack2, i);
                }
                this.tableInventory.setChanged();
                this.xpSeed.set(playerIn.getEnchantmentSeed());
                this.slotsChanged(this.tableInventory);
                p_217003_6_.playSound(null, p_217003_7_, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, p_217003_6_.random.nextFloat() * 0.1f + 0.7f);
            }
        });
        return true;
    }

    private List<EnchantmentInstance> getEnchantmentList(RegistryAccess registryAccess, ItemStack stack, int enchantSlot) {
        this.rand.setSeed((long)(this.xpSeed.get() + enchantSlot));
        Optional optional = registryAccess.registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (optional.isEmpty()) {
            return List.of();
        }
        ArrayList valid = Lists.newArrayList((Iterable)((Iterable)optional.get()));
        valid.removeIf(enchantment -> enchantment.is(EidEnchantmentTagProvider.SOUL_ENCHANTER_BLACKLIST));
        List list = EnchantmentHelper.selectEnchantment((RandomSource)this.rand, (ItemStack)stack, (int)0, valid.stream());
        if (stack.is(Items.BOOK) && list.size() > 1) {
            list.remove(this.rand.nextInt(list.size()));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSoulShardAmount() {
        ItemStack itemstack = this.tableInventory.getItem(1);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getXPSeed() {
        return this.xpSeed.get();
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        this.worldPosCallable.execute((world, pos) -> this.clearContainer(playerIn, this.tableInventory));
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return SoulEnchanterContainer.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)((Block)Registry.SOUL_ENCHANTER.get()));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemstack1.getItem() == Registry.SOUL_SHARD.get()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.slots.get(0)).hasItem() || !((Slot)this.slots.get(0)).mayPlace(itemstack1)) {
                    return ItemStack.EMPTY;
                }
                ItemStack itemstack2 = itemstack1.copy();
                itemstack2.setCount(1);
                itemstack1.shrink(1);
                ((Slot)this.slots.get(0)).set(itemstack2);
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }
}

