/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.research.ResearchTask;
import elucent.eidolon.common.item.ResearchNotesItem;
import elucent.eidolon.gui.ResearchTableContainer;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.ResearchActionPacket;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Researches;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ResearchTableScreen
extends AbstractContainerScreen<ResearchTableContainer> {
    private static final ResourceLocation RESEARCH_TABLE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/gui/research_table.png");

    public ResearchTableScreen(ResearchTableContainer table, Inventory inv, Component p_i51097_3_) {
        super((AbstractContainerMenu)table, inv, p_i51097_3_);
        this.imageHeight = 224;
        this.imageWidth = 192;
    }

    public void render(@NotNull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderLabels(@NotNull GuiGraphics matrixStack, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESEARCH_TABLE_TEXTURE);
        int i = this.leftPos;
        int j = (this.height - this.imageHeight) / 2;
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        mouseX = mouseX * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth();
        mouseY = mouseY * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight();
        if (((Slot)((ResearchTableContainer)this.menu).slots.getFirst()).getItem().getItem() == Registry.RESEARCH_NOTES.get() && ((ResearchTableContainer)this.menu).getProgress() == 0) {
            ItemStack notes = ((Slot)((ResearchTableContainer)this.menu).slots.get(0)).getItem();
            ResearchNotesItem.ResearchData researchData = (ResearchNotesItem.ResearchData)notes.get(EidolonDataComponents.RESEARCH);
            if (researchData == null) {
                return;
            }
            Research r = Researches.find(researchData.research());
            if (r == null) {
                return;
            }
            int nstars = r.getStars();
            int done = researchData.stepsDone();
            if (done < nstars) {
                List<ResearchTask> tasks = r.getTasks(((ResearchTableContainer)this.menu).getSeed(notes), done);
                int slotStart = 38;
                for (int k = 0; k < tasks.size(); ++k) {
                    ResearchTask task = tasks.get(k);
                    int xx = 164;
                    int yy = 16 + 36 * k;
                    if (!this.isHovering(xx + 10, yy + 6, 20, 20, mouseX, mouseY)) continue;
                    task.drawTooltip(matrixStack, this, mouseX - (double)i, mouseY - (double)j);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESEARCH_TABLE_TEXTURE);
                }
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((Slot)((ResearchTableContainer)this.menu).slots.get(0)).getItem().getItem() == Registry.RESEARCH_NOTES.get() && ((ResearchTableContainer)this.menu).getProgress() == 0) {
            ItemStack notes = ((Slot)((ResearchTableContainer)this.menu).slots.get(0)).getItem();
            ResearchNotesItem.ResearchData researchData = (ResearchNotesItem.ResearchData)notes.get(EidolonDataComponents.RESEARCH);
            if (researchData == null) {
                return false;
            }
            Research r = Researches.find(researchData.research());
            if (r == null) {
                return false;
            }
            List<ResearchTask> tasks = r.getTasks(((ResearchTableContainer)this.menu).getSeed(notes), researchData.stepsDone());
            int slotStart = 38;
            for (int k = 0; k < tasks.size(); ++k) {
                ResearchTask task = tasks.get(k);
                int xx = 164;
                int yy = 16 + 36 * k;
                ResearchTask.CompletenessResult isComplete = task.isComplete(this.menu, (Player)Minecraft.getInstance().player, slotStart);
                if (isComplete.complete() && this.isHovering(xx + task.getWidth() - 30, yy + 9, 20, 13, mouseX, mouseY)) {
                    Networking.sendToServer(new ResearchActionPacket(ResearchActionPacket.Action.SUBMIT_GOAL, k));
                    return true;
                }
                slotStart = isComplete.nextSlot();
            }
            int nstars = r.getStars();
            int done = researchData.stepsDone();
            if (done >= nstars && this.isHovering(75, 51, 17, 14, mouseX, mouseY) && !((ResearchTableContainer)this.menu).getSlot(1).getItem().isEmpty()) {
                Networking.sendToServer(new ResearchActionPacket(ResearchActionPacket.Action.STAMP));
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(@Nullable Slot p_97778_, int p_97779_, int p_97780_, @NotNull ClickType p_97781_) {
        if (p_97779_ >= ((ResearchTableContainer)this.menu).slots.size() || p_97778_ == null) {
            return;
        }
        super.slotClicked(p_97778_, p_97779_, p_97780_, p_97781_);
    }

    protected void renderBg(@NotNull GuiGraphics matrixStack, float partialTicks, int x, int y) {
        int i = this.leftPos;
        int j = (this.height - this.imageHeight) / 2;
        matrixStack.blit(RESEARCH_TABLE_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        mouseX = mouseX * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth();
        mouseY = mouseY * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight();
        if (((Slot)((ResearchTableContainer)this.menu).slots.getFirst()).getItem().getItem() == Registry.RESEARCH_NOTES.get()) {
            ItemStack notes = ((Slot)((ResearchTableContainer)this.menu).slots.getFirst()).getItem();
            ResearchNotesItem.ResearchData researchData = (ResearchNotesItem.ResearchData)notes.get(EidolonDataComponents.RESEARCH);
            if (researchData == null) {
                return;
            }
            Research r = Researches.find(researchData.research());
            if (r == null) {
                return;
            }
            int progress = ((ResearchTableContainer)this.menu).getProgress();
            int amt = progress * 104 / 200;
            if (progress > 0) {
                matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + 137, j + 17 + amt, 192, 92 + amt, 9, 104 - amt);
            }
            int nstars = r.getStars();
            int done = researchData.stepsDone();
            if (done < nstars && progress == 0) {
                List<ResearchTask> tasks = r.getTasks(((ResearchTableContainer)this.menu).getSeed(notes), done);
                int slotStart = 38;
                for (int k = 0; k < tasks.size(); ++k) {
                    ResearchTask task = tasks.get(k);
                    int xx = 164;
                    int yy = 16 + 36 * k;
                    matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + xx, j + yy, 80, 224, 8, 32);
                    matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + xx + 8, j + yy, 112, 224, 24, 32);
                    task.drawIcon(matrixStack, RESEARCH_TABLE_TEXTURE, i + xx + 12, j + yy + 8);
                    task.drawCustom(matrixStack, RESEARCH_TABLE_TEXTURE, i + xx + 32, j + yy);
                    ResearchTask.CompletenessResult isComplete = task.isComplete(this.menu, (Player)Minecraft.getInstance().player, slotStart);
                    if (isComplete.complete()) {
                        if (this.isHovering(xx + task.getWidth() - 30, yy + 9, 20, 13, mouseX, mouseY)) {
                            matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 32, j + yy, 184, 224, 24, 32);
                        } else {
                            matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 32, j + yy, 160, 224, 24, 32);
                        }
                    } else {
                        matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 32, j + yy, 136, 224, 24, 32);
                    }
                    matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + xx + task.getWidth() - 8, j + yy, 96, 224, 8, 32);
                    slotStart = isComplete.nextSlot();
                }
            }
            int starsY = 61 + 5 * nstars;
            for (int k = 0; k < nstars; ++k) {
                if (k < done) {
                    matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + 152, j + starsY - k * 10, 201, 82, 9, 10);
                    continue;
                }
                matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + 152, j + starsY - k * 10, 192, 82, 9, 10);
            }
            if (done >= nstars && !((ResearchTableContainer)this.menu).getSlot(1).getItem().isEmpty()) {
                if (this.isHovering(75, 51, 17, 14, mouseX, mouseY)) {
                    matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + 73, j + 49, 234, 64, 21, 18);
                } else {
                    matrixStack.blit(RESEARCH_TABLE_TEXTURE, i + 73, j + 49, 213, 64, 21, 18);
                }
            }
        }
    }
}

