/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import elucent.eidolon.capability.WingsDataImpl;
import elucent.eidolon.client.ClientConfig;
import elucent.eidolon.codex.CodexChapters;
import elucent.eidolon.common.item.IWingsItem;
import elucent.eidolon.registries.EidolonCapabilities;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.util.ClientInfo;
import elucent.eidolon.util.RenderUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.SequencedMap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@EventBusSubscriber(modid="eidolon", value={Dist.CLIENT})
public class ClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    static MultiBufferSource.BufferSource DELAYED_RENDER = null;
    static RenderType[] renderTypes = new RenderType[]{RenderUtil.VAPOR_TRANSLUCENT, RenderUtil.DELAYED_PARTICLE, RenderUtil.GLOWING_PARTICLE, RenderUtil.GLOWING_BLOCK_PARTICLE, RenderUtil.GLOWING, RenderUtil.GLOWING_SPRITE};
    @OnlyIn(value=Dist.CLIENT)
    public static Matrix4f particleMVMatrix = null;
    public static int jumpTicks = 0;
    public static boolean wasJumping = false;

    @OnlyIn(value=Dist.CLIENT)
    public static MultiBufferSource.BufferSource getDelayedRender() {
        if (DELAYED_RENDER == null) {
            SequencedMap buffers = (SequencedMap)Util.make((Object)new Object2ObjectLinkedOpenHashMap(), map -> {
                for (RenderType type : renderTypes) {
                    map.put((Object)type, (Object)new ByteBufferBuilder(ModList.get().isLoaded("rubidium") ? 262144 : type.bufferSize()));
                }
            });
            DELAYED_RENDER = MultiBufferSource.immediateWithBuffers((SequencedMap)buffers, (ByteBufferBuilder)new ByteBufferBuilder(ModList.get().isLoaded("rubidium") ? 262144 : 256));
        }
        return DELAYED_RENDER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLast() {
        ClientInfo.renderTickEnd();
        if (((Boolean)ClientConfig.BETTER_LAYERING.get()).booleanValue()) {
            Matrix4fStack viewStack = RenderSystem.getModelViewStack();
            viewStack.pushMatrix();
            viewStack.identity();
            if (particleMVMatrix != null) {
                viewStack.mul((Matrix4fc)particleMVMatrix);
            }
            RenderSystem.applyModelViewMatrix();
            RenderSystem.blendFunc((int)770, (int)771);
            ClientEvents.getDelayedRender().endBatch(RenderUtil.DELAYED_PARTICLE);
            RenderSystem.blendFunc((int)770, (int)1);
            ClientEvents.getDelayedRender().endBatch(RenderUtil.GLOWING_PARTICLE);
            ClientEvents.getDelayedRender().endBatch(RenderUtil.GLOWING_BLOCK_PARTICLE);
            viewStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
            ClientEvents.getDelayedRender().endBatch(RenderUtil.GLOWING_SPRITE);
            ClientEvents.getDelayedRender().endBatch(RenderUtil.GLOWING);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderStages(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            ClientInfo.renderTickStart(event.getPartialTick().getGameTimeDeltaTicks());
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            ClientEvents.onRenderLast();
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            ClientInfo.clientTicks += event.getPartialTick().getGameTimeDeltaTicks();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide()) {
            return;
        }
        Player p = event.getEntity();
        if (p instanceof LocalPlayer) {
            LocalPlayer lp = (LocalPlayer)p;
            WingsDataImpl wingsData = (WingsDataImpl)lp.getCapability(EidolonCapabilities.WINGS_CAPABILITY);
            if (wingsData == null) {
                return;
            }
            ItemStack wings = wingsData.getWingsItem(p);
            if (!wingsData.canFlap(p)) {
                return;
            }
            if (!(wings.getItem() instanceof IWingsItem)) {
                return;
            }
            if (lp.input.jumping && (!wasJumping || jumpTicks > 0)) {
                if (++jumpTicks > 20) {
                    jumpTicks = 20;
                }
            } else if (wasJumping && jumpTicks > 0) {
                if (jumpTicks >= 20 && !wingsData.isDashing(p)) {
                    wingsData.tryDash(p);
                } else {
                    wingsData.tryFlapWings(p);
                }
                jumpTicks = 0;
            }
            if (p.onGround()) {
                jumpTicks = 0;
            }
            wasJumping = p.onGround() || lp.input.jumping;
        }
    }

    @SubscribeEvent
    public static void TooltipEvent(RenderTooltipEvent.Pre e) {
        CodexChapters.onTooltip(e.getGraphics(), e.getItemStack(), e.getX(), e.getY());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent event) {
        Integer sacred;
        ItemStack itemStack = event.getItemStack();
        Integer necro = (Integer)itemStack.get(EidolonDataComponents.NECROTIC);
        if (necro != null && necro > 0) {
            event.getToolTip().add(Component.translatable((String)"eidolon.tooltip.necrotic").withStyle(ChatFormatting.DARK_BLUE));
        }
        if ((sacred = (Integer)itemStack.get(EidolonDataComponents.CONSECRATED)) != null && sacred > 0) {
            event.getToolTip().add(Component.translatable((String)"eidolon.tooltip.sacred").withStyle(ChatFormatting.GOLD));
        }
    }
}

