/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import elucent.eidolon.registries.DecoBlockPack;
import elucent.eidolon.registries.Registry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;

public class ModLootTables
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public ModLootTables(DataGenerator dataGeneratorIn, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(dataGeneratorIn.getPackOutput(), new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.BLOCK)), lookupProvider);
    }

    public static class BlockLootTable
    extends BlockLootSubProvider {
        public final List<Block> list = new ArrayList<Block>();
        private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        protected BlockLootTable(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> p_249322_) {
            this.generate();
            HashSet<ResourceKey> set = new HashSet<ResourceKey>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceKey resourcelocation;
                if (!block.isEnabled(this.enabledFeatures) || (resourcelocation = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.map.remove(resourcelocation)) == null) continue;
                p_249322_.accept((ResourceKey<LootTable>)resourcelocation, loottable$builder);
            }
        }

        protected void generate() {
            this.registerLeavesAndSticks((Block)Registry.ILLWOOD_LEAVES.get(), (Block)Registry.ILLWOOD_SAPLING.get());
            this.registerDropSelf((Block)Registry.ILLWOOD_SAPLING.get());
            this.registerDropSelf((Block)Registry.ILLWOOD_LOG.get());
            this.registerDropSelf((Block)Registry.ILLWOOD_BARK.get());
            this.registerDropSelf((Block)Registry.STRIPPED_ILLWOOD_LOG.get());
            this.registerDropSelf((Block)Registry.STRIPPED_ILLWOOD_BARK.get());
            this.registerDropSelf(Registry.ILLWOOD_PLANKS);
            this.registerDropSelf(Registry.ELDER_BRICKS);
            this.registerDropSelf(Registry.ELDER_MASONRY);
            this.registerDropSelf(Registry.SMOOTH_STONE_MASONRY);
            this.registerDropSelf(Registry.BONE_PILE);
            this.registerDropSelf((Block)Registry.ELDER_PILLAR.get());
            this.registerDropSelf((Block)Registry.ELDER_BRICKS_EYE.get());
            this.registerDropSelf((Block)Registry.SMOOTH_STONE_ARCH.get());
            this.registerDropSelf((Block)Registry.MOSSY_SMOOTH_STONE_BRICKS.get());
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.dropSelf(block);
        }

        public void registerDropSelf(DecoBlockPack blockpack) {
            ArrayList<Object> blocks = new ArrayList<Object>();
            blocks.add(blockpack.getBlock());
            blocks.add(blockpack.getSlab());
            blocks.add(blockpack.getStairs());
            blocks.add(blockpack.getWall());
            if (blockpack instanceof DecoBlockPack.WoodDecoBlock) {
                DecoBlockPack.WoodDecoBlock woodDecoBlock = (DecoBlockPack.WoodDecoBlock)blockpack;
                blocks.add(woodDecoBlock.getFence());
                blocks.add(woodDecoBlock.getFenceGate());
                blocks.add(woodDecoBlock.getButton());
                blocks.add(woodDecoBlock.getPressurePlate());
                blocks.add(woodDecoBlock.getStandingSign());
                blocks.add(woodDecoBlock.getWallSign());
                blocks.add(woodDecoBlock.getHangingSign());
                blocks.add(woodDecoBlock.getHangingWallSign());
            }
            for (Block block : blocks) {
                if (block == null) continue;
                this.list.add(block);
                this.dropSelf(block);
            }
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.add(leaves, l_state -> this.createLeavesDrops((Block)l_state, sapling, DEFAULT_SAPLING_DROP_RATES));
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return this.list;
        }
    }
}

