/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import elucent.eidolon.Eidolon;
import elucent.eidolon.api.ritual.FocusItemPresentRequirement;
import elucent.eidolon.api.ritual.HealthRequirement;
import elucent.eidolon.api.ritual.ItemRequirement;
import elucent.eidolon.api.ritual.ItemSacrifice;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.AbsorptionRitual;
import elucent.eidolon.common.ritual.AllureRitual;
import elucent.eidolon.common.ritual.CrystalRitual;
import elucent.eidolon.common.ritual.DaylightRitual;
import elucent.eidolon.common.ritual.DeceitRitual;
import elucent.eidolon.common.ritual.MoonlightRitual;
import elucent.eidolon.common.ritual.MultiItemSacrifice;
import elucent.eidolon.common.ritual.PurifyRitual;
import elucent.eidolon.common.ritual.RechargingRitual;
import elucent.eidolon.common.ritual.RepellingRitual;
import elucent.eidolon.datagen.SimpleDataProvider;
import elucent.eidolon.recipe.GenericRitualRecipe;
import elucent.eidolon.recipe.ItemRitualRecipe;
import elucent.eidolon.recipe.LocationRitualRecipe;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.recipe.SummonRitualRecipe;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Worldgen;
import elucent.eidolon.util.RecipeUtil;
import elucent.eidolon.util.RegistryUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

public class EidRitualProvider
extends SimpleDataProvider {
    List<RitualRecipe> rituals = new ArrayList<RitualRecipe>();

    public EidRitualProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addRituals();
        for (RitualRecipe recipe : this.rituals) {
            Path path = EidRitualProvider.getRecipePath(this.output, recipe.getId().getPath());
            this.saveStable(pOutput, (JsonElement)RitualRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), path);
        }
    }

    protected void addRituals() {
        this.makeSummon(Eidolon.prefix("summon_zombie"), EntityType.ZOMBIE, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.ROTTEN_FLESH), List.of(Items.ROTTEN_FLESH));
        this.makeSummon(Eidolon.prefix("summon_skeleton"), EntityType.SKELETON, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.BONE), List.of(Items.BONE));
        this.makeSummon(Eidolon.prefix("summon_phantom"), EntityType.PHANTOM, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.PHANTOM_MEMBRANE), List.of(Items.PHANTOM_MEMBRANE));
        this.makeSummon(Eidolon.prefix("summon_creeper"), EntityType.CREEPER, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.GUNPOWDER), List.of(Items.GUNPOWDER));
        this.makeSummon(Eidolon.prefix("summon_wither_skeleton"), EntityType.WITHER_SKELETON, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.BONE), List.of(Blocks.SOUL_SAND));
        this.makeSummon(Eidolon.prefix("summon_husk"), EntityType.STRAY, 3, (ItemLike)Items.CHARCOAL, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.ROTTEN_FLESH)), List.of(Ingredient.of((TagKey)Tags.Items.SANDS)));
        this.makeSummon(Eidolon.prefix("summon_drowned"), EntityType.DROWNED, 3, (ItemLike)Items.CHARCOAL, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.ROTTEN_FLESH)), List.of(Ingredient.of((TagKey)Tags.Items.GEMS_PRISMARINE)));
        this.makeSummon(Eidolon.prefix("summon_stray"), EntityType.STRAY, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.BONE), List.of(Items.STRING));
        this.makeSummon(Eidolon.prefix("summon_wraith"), (EntityType)EidolonEntities.WRAITH.get(), List.of((ItemLike)Registry.SOUL_SHARD.get(), (ItemLike)Registry.TATTERED_CLOTH.get()), List.of((ItemLike)Registry.TATTERED_CLOTH.get()));
        this.makeSummon(Eidolon.prefix("summon_slugs"), (EntityType)EidolonEntities.SLIMY_SLUG.get(), 3, (ItemLike)Items.PUMPKIN_SEEDS, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.SLIME_BALL)), List.of());
        this.makeSummon(Eidolon.prefix("summon_ravens"), (EntityType)EidolonEntities.RAVEN.get(), 3, (ItemLike)Items.BEETROOT_SEEDS, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.FEATHER)), List.of());
        Ingredient harmingIngredient = DataComponentIngredient.of((boolean)true, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.HARMING), (ItemLike[])new ItemLike[]{Items.POTION});
        this.crafting(((Item)Registry.SAPPING_SWORD.get()).getDefaultInstance(), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_SWORD}), RecipeUtil.ingredientsFromObjects(List.of(Registry.SHADOW_GEM.get(), Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Items.NETHER_WART, Items.NETHER_WART, Items.GHAST_TEAR)), List.of(harmingIngredient), 20);
        this.crafting(((Item)Registry.SANGUINE_AMULET.get()).getDefaultInstance(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registry.BASIC_AMULET.get()}), RecipeUtil.ingredientsFromObjects(List.of(Tags.Items.GEMS_DIAMOND, Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Registry.LESSER_SOUL_GEM.get())), List.of(harmingIngredient), 40);
        this.generic((ItemLike)Items.BONE_MEAL, new CrystalRitual().setRegistryName("eidolon", "crystal").addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)));
        this.generic((TagKey<Item>)Tags.Items.GEMS_EMERALD, new DeceitRitual().setRegistryName("eidolon", "deceit").addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.GEMS_EMERALD)).addRequirement(new ItemRequirement(Items.FERMENTED_SPIDER_EYE)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.MUSHROOMS)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.ROSE_BUSH, new AllureRitual().setRegistryName("eidolon", "allure").addRequirement(new ItemRequirement(Items.GOLDEN_APPLE)).addRequirement(new ItemRequirement(Items.RED_DYE)).addRequirement(new ItemRequirement(Items.RED_DYE)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.NAUTILUS_SHELL, new RepellingRitual().setRegistryName("eidolon", "repelling").addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.INGOTS_IRON)).addRequirement(new ItemRequirement(Items.LEATHER)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.GEMS_QUARTZ)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.SUNFLOWER, new DaylightRitual().setRegistryName("eidolon", "daylight").addRequirement(new ItemRequirement(Items.CHARCOAL)).addRequirement(new ItemRequirement(Items.WHEAT_SEEDS)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((TagKey<Item>)Tags.Items.DYES_BLACK, new MoonlightRitual().setRegistryName("eidolon", "moonlight").addRequirement(new ItemRequirement(Items.SNOWBALL)).addRequirement(new ItemRequirement(Items.SPIDER_EYE)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.GLISTERING_MELON_SLICE, new PurifyRitual().setRegistryName("eidolon", "purify").addRequirement(new ItemRequirement((Block)Registry.ENCHANTED_ASH.get())).addRequirement(new ItemRequirement((Block)Registry.ENCHANTED_ASH.get())).addRequirement(new ItemRequirement(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.HEALING))).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Registry.DEATH_ESSENCE.get(), new AbsorptionRitual().setRegistryName("eidolon", "absorption").addRequirement(new ItemRequirement((Item)Registry.TATTERED_CLOTH.get())).addRequirement(new ItemRequirement((Item)Registry.TATTERED_CLOTH.get())).addRequirement(new ItemRequirement(Items.BONE)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addInvariant(new FocusItemPresentRequirement((ItemLike)Registry.SUMMONING_STAFF.get())));
        this.generic((ItemLike)Registry.LESSER_SOUL_GEM.get(), new RechargingRitual().setRegistryName("eidolon", "recharging_soulfire").addRequirement(new ItemRequirement(Items.BLAZE_POWDER)).addRequirement(new ItemRequirement(Items.BLAZE_POWDER)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).addInvariant(new FocusItemPresentRequirement((ItemLike)Registry.SOULFIRE_WAND.get())));
        this.generic((ItemLike)Registry.LESSER_SOUL_GEM.get(), new RechargingRitual().setRegistryName("eidolon", "recharging_chill").addRequirement(new ItemRequirement(Items.SNOWBALL)).addRequirement(new ItemRequirement(Items.SNOWBALL)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).addInvariant(new FocusItemPresentRequirement((ItemLike)Registry.BONECHILL_WAND.get())));
        this.location(Worldgen.CATACOMBS, Eidolon.prefix("ritual_catacomb_locator"), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAP}), RecipeUtil.ingredientsFromObjects(List.of(Items.COMPASS, Registry.MAGIC_INK.get(), Registry.RAVEN_FEATHER.get())), List.of(), 0);
    }

    public void crafting(ItemStack result, Ingredient reagent, List<Ingredient> pedestal, List<Ingredient> foci, int healthCost) {
        this.rituals.add(new ItemRitualRecipe(reagent, foci, pedestal, result, true, healthCost));
    }

    public void location(TagKey<Structure> structureTagKey, ResourceLocation location, Ingredient reagent, List<Ingredient> pedestal, List<Ingredient> foci, int healthCost) {
        this.rituals.add(new LocationRitualRecipe(structureTagKey.location(), reagent, pedestal, foci, (float)healthCost));
    }

    public void makeSummon(EntityType<?> type, ItemLike item, List<Ingredient> pedestal, List<Ingredient> foci) {
        this.rituals.add(new SummonRitualRecipe(RegistryUtil.getRegistryName(type), Ingredient.of((ItemLike[])new ItemLike[]{item}), pedestal, foci));
    }

    public void makeSummon(ResourceLocation id, EntityType<?> type, int count, ItemLike item, List<Ingredient> pedestal, List<Ingredient> foci) {
        this.rituals.add(new SummonRitualRecipe(RegistryUtil.getRegistryName(type), Ingredient.of((ItemLike[])new ItemLike[]{item}), pedestal, foci, count, 0.0f));
    }

    public void makeSummon(ResourceLocation id, EntityType<?> type, List<ItemLike> pedestal, List<ItemLike> foci) {
        this.makeSummon(type, (ItemLike)Items.CHARCOAL, pedestal.stream().map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0})).toList(), foci.stream().map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0})).toList());
    }

    public void generic(ItemLike item, Ritual ritual) {
        this.generic(new ItemSacrifice(item), ritual);
    }

    public void generic(TagKey<Item> item, Ritual ritual) {
        this.generic(new ItemSacrifice(item), ritual);
    }

    public void generic(ItemSacrifice keys, Ritual ritual) {
        List<Ingredient> list;
        List<Ingredient> pedestal = ritual.getRequirements().stream().filter(req -> req instanceof ItemRequirement).map(req -> (ItemRequirement)req).map(ItemRequirement::getMatch).toList();
        Ingredient reagent = keys.main;
        if (keys instanceof MultiItemSacrifice) {
            MultiItemSacrifice mis = (MultiItemSacrifice)keys;
            list = mis.items;
        } else {
            list = List.of();
        }
        List<Ingredient> foci = list;
        List<Ingredient> invariants = ritual.getInvariants().stream().filter(iRequirement -> iRequirement instanceof FocusItemPresentRequirement).map(iRequirement -> (FocusItemPresentRequirement)iRequirement).map(FocusItemPresentRequirement::getMatch).collect(Collectors.toList());
        float health = ritual.getRequirements().stream().filter(req -> req instanceof HealthRequirement).map(req -> (HealthRequirement)req).map(HealthRequirement::getHealth).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
        this.rituals.add(new GenericRitualRecipe(ritual.getRegistryName(), reagent, pedestal, foci, invariants, health));
    }

    @NotNull
    public String getName() {
        return "Eidolon Rituals";
    }

    protected static Path getRecipePath(Path pathIn, Item item) {
        return EidRitualProvider.getRecipePath(pathIn, RegistryUtil.getRegistryName(item).getPath());
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/eidolon/recipes/rituals/" + str + ".json");
    }
}

