/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import elucent.eidolon.Eidolon;
import elucent.eidolon.registries.DecoBlockPack;
import elucent.eidolon.registries.Registry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import org.jetbrains.annotations.NotNull;

public class EidRecipeProvider
extends RecipeProvider {
    private static int STONECUTTER_COUNTER = 0;

    public EidRecipeProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider) {
        super(pGenerator.getPackOutput(), provider);
    }

    protected void buildRecipes(@NotNull RecipeOutput pFinishedRecipeConsumer) {
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.ILLWOOD_PLANKS);
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.ELDER_BRICKS, List.of((Block)Registry.ELDER_BRICKS_EYE.get(), (Block)Registry.ELDER_PILLAR.get(), Registry.ELDER_MASONRY.getBlock()));
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.ELDER_MASONRY);
        EidRecipeProvider.makeStonecutter(pFinishedRecipeConsumer, (ItemLike)Blocks.SMOOTH_STONE, (ItemLike)Registry.SMOOTH_STONE_MASONRY.getBlock(), "smooth_stone_masonry");
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.SMOOTH_STONE_MASONRY);
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.BONE_PILE);
        this.buildDecoPack(pFinishedRecipeConsumer, Registry.POLISHED_PLANKS);
        EidRecipeProvider.makeStonecutter(pFinishedRecipeConsumer, (ItemLike)Registry.SMOOTH_STONE_BRICK.getBlock(), (ItemLike)Registry.SMOOTH_STONE_ARCH.get(), "smooth_stone_arch");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)Registry.MOSSY_SMOOTH_STONE_BRICKS.get())).requires((ItemLike)Registry.SMOOTH_STONE_BRICK.getBlock()).requires((ItemLike)Items.VINE).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Registry.SMOOTH_STONE_BRICK.getBlock()})).save(pFinishedRecipeConsumer, Eidolon.prefix("mossy_smooth_stone_bricks"));
        EidRecipeProvider.woodFromLogs((RecipeOutput)pFinishedRecipeConsumer, (ItemLike)((ItemLike)Registry.ILLWOOD_BARK.get()), (ItemLike)((ItemLike)Registry.ILLWOOD_LOG.get()));
        EidRecipeProvider.planksFromLog((RecipeOutput)pFinishedRecipeConsumer, (ItemLike)Registry.ILLWOOD_PLANKS.getBlock(), Registry.ILLWOOD_LOGS, (int)4);
        EidRecipeProvider.strippedLogToWood(pFinishedRecipeConsumer, (ItemLike)Registry.STRIPPED_ILLWOOD_LOG.get(), (ItemLike)Registry.STRIPPED_ILLWOOD_BARK.get());
    }

    private void buildDecoPack(RecipeOutput consumer, DecoBlockPack decoBlockPack, List<Block> extras) {
        Block block = decoBlockPack.getBlock();
        this.makeSlab(consumer, block, decoBlockPack.getSlab(), decoBlockPack.baseBlockName);
        this.makeStairs(consumer, block, decoBlockPack.getStairs(), decoBlockPack.baseBlockName);
        EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)decoBlockPack.getSlab(), 2, decoBlockPack.baseBlockName);
        EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)decoBlockPack.getStairs(), decoBlockPack.baseBlockName);
        if (decoBlockPack.getWall() != null) {
            this.makeWall(consumer, block, decoBlockPack.getWall(), decoBlockPack.baseBlockName);
            EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)decoBlockPack.getWall(), decoBlockPack.baseBlockName);
        }
        if (decoBlockPack.getPressurePlate() != null) {
            this.makePressurePlate(consumer, block, (Block)decoBlockPack.getPressurePlate(), decoBlockPack.baseBlockName);
        }
        if (decoBlockPack instanceof DecoBlockPack.WoodDecoBlock) {
            DecoBlockPack.WoodDecoBlock woodDecoBlock = (DecoBlockPack.WoodDecoBlock)decoBlockPack;
            if (woodDecoBlock.getFence() != null) {
                this.makeFence(consumer, block, woodDecoBlock.getFence(), decoBlockPack.baseBlockName);
                EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)woodDecoBlock.getFence(), decoBlockPack.baseBlockName);
            }
            if (woodDecoBlock.getFenceGate() != null) {
                this.makeGate(consumer, block, woodDecoBlock.getFenceGate(), decoBlockPack.baseBlockName);
                EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)woodDecoBlock.getFence(), decoBlockPack.baseBlockName);
            }
            if (woodDecoBlock.getButton() != null) {
                this.makeButton(consumer, block, woodDecoBlock.getButton(), decoBlockPack.baseBlockName);
            }
            if (woodDecoBlock.getStandingSign() != null) {
                EidRecipeProvider.makeSign(consumer, decoBlockPack, woodDecoBlock, block);
            }
            if (woodDecoBlock.getHangingSign() != null) {
                EidRecipeProvider.makeHSign(consumer, decoBlockPack, woodDecoBlock, block);
            }
        }
        for (Block extra : extras) {
            EidRecipeProvider.makeStonecutter(consumer, (ItemLike)block, (ItemLike)extra, decoBlockPack.baseBlockName);
        }
        STONECUTTER_COUNTER = 0;
    }

    private static void makeSign(RecipeOutput consumer, DecoBlockPack decoBlockPack, DecoBlockPack.WoodDecoBlock woodDecoBlock, Block block) {
        EidRecipeProvider.signBuilder((ItemLike)woodDecoBlock.getStandingSign(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block})).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(decoBlockPack.baseBlockName + "_sign")));
    }

    private static void makeHSign(RecipeOutput consumer, DecoBlockPack decoBlockPack, DecoBlockPack.WoodDecoBlock woodDecoBlock, Block block) {
        EidRecipeProvider.hSignBuilder((ItemLike)woodDecoBlock.getHangingSign(), Ingredient.of((ItemLike[])new ItemLike[]{block})).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(decoBlockPack.baseBlockName + "_hanging_sign")));
    }

    protected static RecipeBuilder hSignBuilder(ItemLike pSign, Ingredient pMaterial) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)pSign, (int)6).group("hanging_sign").define(Character.valueOf('#'), pMaterial).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###");
    }

    private void makeButton(RecipeOutput consumer, Block block, ButtonBlock button, String baseBlockName) {
        EidRecipeProvider.buttonBuilder((ItemLike)button, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block})).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(baseBlockName + "_button")));
    }

    private void buildDecoPack(RecipeOutput consumer, DecoBlockPack decoBlockPack) {
        this.buildDecoPack(consumer, decoBlockPack, List.of());
    }

    private void makeDoor(RecipeOutput consumer, Block block, Block door, String basename) {
        EidRecipeProvider.doorBuilder((ItemLike)door, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block})).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(basename + "_door")));
    }

    private void makePressurePlate(RecipeOutput consumer, Block block, Block pressurePlate, String basename) {
        EidRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)pressurePlate, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block})).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(basename + "_pressure_plate")));
    }

    private void makeSlab(RecipeOutput consumer, Block block, Block slab, String basename) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)slab, (int)6).pattern("BBB").define(Character.valueOf('B'), (ItemLike)block).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(basename + "_slab")));
    }

    private void makeWall(RecipeOutput consumer, Block block, Block wall, String basename) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wall, (int)6).pattern("BBB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)block).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(basename + "_wall")));
    }

    private void makeStairs(RecipeOutput consumer, Block block, Block stairs, String basename) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairs, (int)4).pattern("B  ").pattern("BB ").pattern("BBB").define(Character.valueOf('B'), (ItemLike)block).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(basename + "_stair")));
    }

    private void makeFence(RecipeOutput consumer, Block block, Block fence, String basename) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).pattern("BSB").pattern("BSB").define(Character.valueOf('B'), (ItemLike)block).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(basename + "_fence")));
    }

    private void makeGate(RecipeOutput consumer, Block block, Block gate, String basename) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)gate, (int)1).pattern("SBS").pattern("SBS").define(Character.valueOf('B'), (ItemLike)block).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(basename + "_gate")));
    }

    public static void makeStonecutter(RecipeOutput consumer, ItemLike input, ItemLike output, String reg) {
        EidRecipeProvider.makeStonecutter(consumer, input, output, 1, reg);
    }

    public static void makeStonecutter(RecipeOutput consumer, ItemLike input, ItemLike output, int quantity, String reg) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)quantity).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{input})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)(reg + "_stonecutter_" + STONECUTTER_COUNTER)));
        ++STONECUTTER_COUNTER;
    }

    private static void strippedLogToWood(RecipeOutput recipeConsumer, ItemLike stripped, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).define(Character.valueOf('#'), stripped).pattern("##").pattern("##").group("bark").unlockedBy("has_illwood", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{stripped})).save(recipeConsumer);
    }
}

