/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import elucent.eidolon.registries.Registry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidItemTagProvider
extends ItemTagsProvider {
    public static final TagKey<Item> SCRIBE_ITEMS = EidItemTagProvider.eidolonItemTag("scribe_items");
    public static final TagKey<Item> PATRON_SYMBOL = EidItemTagProvider.eidolonItemTag("patron_symbol");

    public EidItemTagProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider, BlockTagsProvider pBlockTagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(pGenerator.getPackOutput(), provider, pBlockTagsProvider.contentsGetter(), "eidolon", existingFileHelper);
    }

    @NotNull
    private static TagKey<Item> eidolonItemTag(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)name));
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.tag(Tags.Items.MUSIC_DISCS).add((Object)((Item)Registry.PAROUSIA_DISC.get()));
        this.tag(SCRIBE_ITEMS).add((Object[])new Item[]{Items.CHARCOAL, Items.FEATHER, Items.BOOK, ((Block)Registry.CANDLE.get()).asItem(), (Item)Registry.PARCHMENT.get(), (Item)Registry.MAGIC_INK.get()});
        this.tag(PATRON_SYMBOL).add((Object[])new Item[]{(Item)Registry.HOLY_SYMBOL.get(), (Item)Registry.UNHOLY_SYMBOL.get()});
        this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
        this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
        this.copy(BlockTags.WOODEN_BUTTONS, ItemTags.WOODEN_BUTTONS);
        this.copy(BlockTags.CANDLES, ItemTags.CANDLES);
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)Registry.CODEX.get()));
        this.tag(ItemTags.LECTERN_BOOKS).add((Object)((Item)Registry.CODEX.get()));
        this.tag(ItemTags.SIGNS).add((Object[])new Item[]{Registry.ILLWOOD_PLANKS.getStandingSign().asItem(), Registry.POLISHED_PLANKS.getStandingSign().asItem()});
        this.copy(BlockTags.WOODEN_PRESSURE_PLATES, ItemTags.WOODEN_PRESSURE_PLATES);
    }
}

