/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import com.google.common.collect.Maps;
import elucent.eidolon.registries.AdvancementTriggers;
import elucent.eidolon.registries.Registry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.extensions.IAdvancementBuilderExtension;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidAdvancementProvider
extends AdvancementProvider {
    public EidAdvancementProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper fileHelperIn) {
        super(generatorIn.getPackOutput(), registries, fileHelperIn, List.of(new EidolonAdvancements()));
    }

    static class EidolonAdvancements
    implements AdvancementProvider.AdvancementGenerator {
        Consumer<AdvancementHolder> advCon;

        EidolonAdvancements() {
        }

        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider registries, @NotNull Consumer<AdvancementHolder> con, @NotNull ExistingFileHelper existingFileHelper) {
            this.advCon = con;
            AdvancementHolder root = this.builder("eidolon").display((ItemLike)Registry.CODEX.get(), (Component)Component.translatable((String)"eidolon.advancement.title.root"), (Component)Component.translatable((String)"eidolon.advancement.desc.root"), ResourceLocation.tryParse((String)"eidolon:textures/block/bone_pile.png"), AdvancementType.TASK, false, false, false).addCriterion("eidolon:ars_ecclesia", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Registry.CODEX.get()})).save(con, "eidolon:root");
            AdvancementHolder theurgy = this.saveBasicItem((ItemLike)Registry.STRAW_EFFIGY.get(), root);
            AdvancementHolder altar = this.saveBasicItem((ItemLike)Registry.WOODEN_ALTAR.get(), theurgy);
            this.saveBasicItem((ItemLike)Registry.STONE_ALTAR.get(), altar);
            AdvancementHolder sacredRoot = this.saveWithTrigger(theurgy, (ItemLike)Registry.HOLY_SYMBOL.get(), AdvancementTriggers.SACRED);
            AdvancementHolder incense = this.saveWithTrigger(sacredRoot, (ItemLike)Registry.CENSER.get(), AdvancementTriggers.INCENSE);
            AdvancementHolder darkRoot = this.saveWithTrigger(theurgy, (ItemLike)Registry.UNHOLY_SYMBOL.get(), AdvancementTriggers.WICKED);
            AdvancementHolder goblet = this.saveWithTrigger(darkRoot, (ItemLike)Registry.GOBLET.get(), AdvancementTriggers.SACRIFICE);
            AdvancementHolder symbol = this.saveBasicItem((ItemLike)Registry.HOLY_SYMBOL.get(), incense);
            AdvancementHolder layHands = this.saveWithTrigger(symbol, (ItemLike)Items.GLISTERING_MELON_SLICE, AdvancementTriggers.LAY_ON_HANDS);
            AdvancementHolder cureZombie = this.saveWithTrigger(layHands, (ItemLike)Items.GOLDEN_APPLE, AdvancementTriggers.CURE_ZOMBIE);
            AdvancementHolder smite = this.saveWithTrigger(cureZombie, (ItemLike)Items.GOLDEN_SWORD, AdvancementTriggers.SMITE);
            symbol = this.saveBasicItem((ItemLike)Registry.UNHOLY_SYMBOL.get(), goblet);
            AdvancementHolder v_sacrifice = this.saveWithTrigger(symbol, (ItemLike)Items.IRON_SWORD, AdvancementTriggers.VSACRIFICE);
            AdvancementHolder zombify = this.saveWithTrigger(v_sacrifice, (ItemLike)Registry.ZOMBIE_HEART.get(), AdvancementTriggers.ZOMBIFY);
            AdvancementHolder enthrall = this.saveWithTrigger(zombify, (ItemLike)Registry.SUMMONING_STAFF.get(), AdvancementTriggers.ENTHRALL);
            AdvancementHolder artificeRoot = this.saveBasicItem((ItemLike)Registry.PEWTER_INGOT.get(), root);
            AdvancementHolder alchemy = this.saveBasicItem((ItemLike)Registry.CRUCIBLE.get(), artificeRoot);
            AdvancementHolder researchs = this.saveBasicItem((ItemLike)Registry.RESEARCH_NOTES.get(), alchemy);
            this.saveWithTrigger(researchs, (ItemLike)Blocks.CAMPFIRE, AdvancementTriggers.FLAME);
            this.saveWithTrigger(researchs, (ItemLike)Blocks.BLUE_ICE, AdvancementTriggers.FROST);
            AdvancementHolder apothecary = this.saveBasicItem((ItemLike)Registry.WOODEN_STAND.get(), alchemy);
            AdvancementHolder worktable = this.saveBasicItem((ItemLike)Registry.WORKTABLE.get(), artificeRoot);
            AdvancementHolder athame = this.saveBasicItem((ItemLike)Registry.ATHAME.get(), worktable);
            AdvancementHolder scythe = this.saveBasicItem((ItemLike)Registry.REAPER_SCYTHE.get(), worktable);
            AdvancementHolder braziers = this.saveBasicItem((ItemLike)Registry.BRAZIER.get(), artificeRoot);
            AdvancementHolder soulShard = this.saveBasicItem((ItemLike)Registry.SOUL_SHARD.get(), braziers);
        }

        private AdvancementHolder saveWithTrigger(AdvancementHolder parent, @NotNull ItemLike display, DeferredHolder<CriterionTrigger<?>, PlayerTrigger> playerTrigger) {
            return this.builder(playerTrigger.getId().getPath()).display(display, AdvancementType.TASK).addCriterion(AdvancementTriggers.createCriterion(playerTrigger)).parent(parent).save(this.advCon);
        }

        public AdvancementBuilder buildBasicItem(ItemLike item, AdvancementHolder parent) {
            return this.builder(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath()).normalItemRequirement(item).parent(parent);
        }

        public AdvancementHolder saveBasicItem(ItemLike item, AdvancementHolder parent) {
            return this.buildBasicItem(item, parent).save(this.advCon);
        }

        public AdvancementBuilder builder(String key) {
            return AdvancementBuilder.builder("eidolon", key);
        }
    }

    static class AdvancementBuilder
    implements IAdvancementBuilderExtension {
        @Nullable
        private ResourceLocation parentId;
        @Nullable
        private AdvancementHolder parent;
        @Nullable
        private DisplayInfo display;
        private AdvancementRewards rewards = AdvancementRewards.EMPTY;
        private Map<String, Criterion<?>> criteria = Maps.newLinkedHashMap();
        @Nullable
        private AdvancementRequirements requirements;
        private AdvancementRequirements.Strategy requirementsStrategy = AdvancementRequirements.Strategy.AND;
        private String modid;
        private String fileKey;

        private AdvancementBuilder(@Nullable ResourceLocation pParentId, @Nullable DisplayInfo pDisplay, AdvancementRewards pRewards, Map<String, Criterion<?>> pCriteria, AdvancementRequirements pRequirements) {
            this.parentId = pParentId;
            this.display = pDisplay;
            this.rewards = pRewards;
            this.criteria = pCriteria;
            this.requirements = pRequirements;
        }

        private AdvancementBuilder(String modid, String fileKey) {
            this.modid = modid;
            this.fileKey = fileKey;
        }

        public static AdvancementBuilder builder(String modid, String fileKey) {
            return new AdvancementBuilder(modid, fileKey);
        }

        public AdvancementBuilder parent(AdvancementHolder parent) {
            this.parent = parent;
            return this.parent(parent.id());
        }

        public AdvancementBuilder parent(ResourceLocation pParentId) {
            this.parentId = pParentId;
            return this;
        }

        public AdvancementBuilder display(ItemStack pStack, Component pTitle, Component pDescription, @Nullable ResourceLocation pBackground, AdvancementType pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
            return this.display(new DisplayInfo(pStack, pTitle, pDescription, Optional.ofNullable(pBackground), pFrame, pShowToast, pAnnounceToChat, pHidden));
        }

        public AdvancementBuilder display(ItemLike pItem, Component pTitle, Component pDescription, @Nullable ResourceLocation pBackground, AdvancementType pFrame, boolean pShowToast, boolean pAnnounceToChat, boolean pHidden) {
            return this.display(new DisplayInfo(new ItemStack((ItemLike)pItem.asItem()), pTitle, pDescription, Optional.ofNullable(pBackground), pFrame, pShowToast, pAnnounceToChat, pHidden));
        }

        public AdvancementBuilder display(DisplayInfo pDisplay) {
            this.display = pDisplay;
            return this;
        }

        public AdvancementBuilder display(ItemStack pItem, AdvancementType pFrame) {
            return this.display(new DisplayInfo(pItem, (Component)this.getComponent("title"), (Component)this.getComponent("desc"), Optional.empty(), pFrame, true, true, false));
        }

        public AdvancementBuilder display(ItemLike pItem, AdvancementType pFrame) {
            return this.display(new ItemStack(pItem), pFrame);
        }

        public AdvancementBuilder display(ItemStack pItem, AdvancementType pFrame, boolean hidden) {
            return this.display(new DisplayInfo(pItem, (Component)this.getComponent("title"), (Component)this.getComponent("desc"), Optional.empty(), pFrame, true, true, hidden));
        }

        public AdvancementBuilder display(ItemLike pItem, AdvancementType pFrame, boolean hidden) {
            return this.display(new ItemStack(pItem), pFrame, hidden);
        }

        public AdvancementBuilder rewards(AdvancementRewards.Builder pRewardsBuilder) {
            return this.rewards(pRewardsBuilder.build());
        }

        public AdvancementBuilder rewards(AdvancementRewards pRewards) {
            this.rewards = pRewards;
            return this;
        }

        public AdvancementBuilder addCriterion(Criterion<?> pCriterion) {
            return this.addCriterion(this.fileKey, pCriterion);
        }

        public AdvancementBuilder addCriterion(String pKey, Criterion<?> pCriterion) {
            if (this.criteria.containsKey(pKey)) {
                throw new IllegalArgumentException("Duplicate criterion " + pKey);
            }
            this.criteria.put(pKey, pCriterion);
            return this;
        }

        public AdvancementBuilder requirements(AdvancementRequirements.Strategy pStrategy) {
            this.requirementsStrategy = pStrategy;
            return this;
        }

        public AdvancementBuilder requirements(AdvancementRequirements pRequirements) {
            this.requirements = pRequirements;
            return this;
        }

        public AdvancementBuilder normalItemRequirement(ItemLike item) {
            return this.display(item, AdvancementType.TASK).requireItem(item);
        }

        public AdvancementBuilder requireItem(ItemLike item) {
            return this.addCriterion("has_" + BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
        }

        public MutableComponent getComponent(String type) {
            return Component.translatable((String)(this.modid + ".advancement." + type + "." + this.fileKey));
        }

        public Advancement build() {
            if (this.requirements == null) {
                this.requirements = this.requirementsStrategy.create(this.criteria.keySet());
            }
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("Advancement " + this.fileKey + " has no criteria " + String.valueOf(this));
            }
            return new Advancement(Optional.ofNullable(this.parentId), Optional.ofNullable(this.display), this.rewards, this.criteria, this.requirements, false);
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> pConsumer, String pId) {
            return this.save(pConsumer, ResourceLocation.tryParse((String)pId));
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> pConsumer, ResourceLocation pId) {
            Advancement adv = this.build();
            AdvancementHolder advancement = new AdvancementHolder(pId, adv);
            pConsumer.accept(advancement);
            return advancement;
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> pConsumer) {
            return this.save(pConsumer, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)this.fileKey));
        }

        public String toString() {
            return "Task Advancement{parentId=" + String.valueOf(this.parentId) + ", display=" + String.valueOf(this.display) + ", rewards=" + String.valueOf(this.rewards) + ", criteria=" + String.valueOf(this.criteria) + ", requirements=" + String.valueOf(this.requirements) + "}";
        }

        public Map<String, Criterion<?>> getCriteria() {
            return this.criteria;
        }
    }
}

