/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import elucent.eidolon.datagen.EidAdvancementProvider;
import elucent.eidolon.datagen.EidBiomeTagProvider;
import elucent.eidolon.datagen.EidBlockStateProvider;
import elucent.eidolon.datagen.EidBlockTagProvider;
import elucent.eidolon.datagen.EidChantProvider;
import elucent.eidolon.datagen.EidDamageProvider;
import elucent.eidolon.datagen.EidEnchantmentTagProvider;
import elucent.eidolon.datagen.EidEntityTagProvider;
import elucent.eidolon.datagen.EidForagingProvider;
import elucent.eidolon.datagen.EidItemTagProvider;
import elucent.eidolon.datagen.EidRecipeProvider;
import elucent.eidolon.datagen.EidRitualProvider;
import elucent.eidolon.datagen.EidWorldgenProvider;
import elucent.eidolon.datagen.ModLootTables;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="eidolon")
public class Datagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new EidBlockStateProvider(gen, fileHelper));
        EidBlockTagProvider blockGen = new EidBlockTagProvider(gen, provider, fileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockGen);
        gen.addProvider(event.includeServer(), (DataProvider)new EidItemTagProvider(gen, provider, blockGen, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModLootTables(gen, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidRecipeProvider(gen, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidBiomeTagProvider(gen, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidWorldgenProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidDamageProvider.DamageTypeDataProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new EidDamageProvider.DamageTypeTagGen(output, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidRitualProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new EidChantProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new EidForagingProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new EidAdvancementProvider(gen, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidEnchantmentTagProvider(gen, provider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new EidEntityTagProvider(gen, provider, fileHelper));
    }
}

