/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.common.block.WoodenStandBlock;
import elucent.eidolon.common.tile.CrucibleTileEntity;
import elucent.eidolon.gui.WoodenBrewingStandContainer;
import elucent.eidolon.registries.Registry;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class WoodenStandTileEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUT_SLOTS = new int[]{0, 1, 2};
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private int brewTime;
    private int heat;
    private boolean[] filledSlots;
    private Item ingredientID;
    public final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> WoodenStandTileEntity.this.brewTime;
                case 1 -> WoodenStandTileEntity.this.heat;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    WoodenStandTileEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    WoodenStandTileEntity.this.heat = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public WoodenStandTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.WOODEN_STAND_TILE_ENTITY.get(), pos, state);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.eidolon.wooden_brewing_stand");
    }

    public int getContainerSize() {
        return this.brewingItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        boolean[] aboolean;
        BlockEntity below;
        if (this.level == null) {
            return;
        }
        boolean flag = this.canBrew(this.level.potionBrewing());
        boolean flag1 = this.brewTime > 0;
        ItemStack itemstack1 = (ItemStack)this.brewingItemStacks.get(3);
        if (this.level != null && this.level.getGameTime() % 20L == 0L && (below = this.level.getBlockEntity(this.worldPosition.below())) instanceof CrucibleTileEntity) {
            CrucibleTileEntity crucibleTileEntity = (CrucibleTileEntity)below;
            int prevHeat = this.heat;
            int n = this.heat = crucibleTileEntity.boiling ? 1 : 0;
            if (prevHeat != this.heat) {
                this.setChanged();
            }
        }
        if (flag1) {
            boolean flag2;
            --this.brewTime;
            boolean bl = flag2 = this.brewTime == 0;
            if (flag2 && flag) {
                WoodenStandTileEntity.doBrew(this.level, this.getBlockPos(), this.brewingItemStacks);
                this.setChanged();
            } else if (!flag || this.heat == 0) {
                this.brewTime = 0;
                this.setChanged();
            } else if (this.ingredientID != itemstack1.getItem()) {
                this.brewTime = 0;
                this.setChanged();
            }
        } else if (flag && this.heat > 0) {
            this.brewTime = 800;
            this.ingredientID = itemstack1.getItem();
            this.setChanged();
        }
        if (!this.level.isClientSide && !Arrays.equals(aboolean = this.createFilledSlotsArray(), this.filledSlots)) {
            this.filledSlots = aboolean;
            BlockState blockstate = this.level.getBlockState(this.getBlockPos());
            if (!(blockstate.getBlock() instanceof WoodenStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.HAS_BOTTLE.length; ++i) {
                blockstate = (BlockState)blockstate.setValue((Property)BrewingStandBlock.HAS_BOTTLE[i], (Comparable)Boolean.valueOf(aboolean[i]));
            }
            this.level.setBlock(this.worldPosition, blockstate, 2);
        }
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.brewingItemStacks.get(i)).isEmpty()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean canBrew(PotionBrewing potionBrewing) {
        ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(3);
        if (itemstack.isEmpty()) {
            return false;
        }
        if (!potionBrewing.isIngredient(itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = (ItemStack)this.brewingItemStacks.get(i);
            if (itemstack1.isEmpty() || !potionBrewing.hasMix(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(Level level, BlockPos pos, NonNullList<ItemStack> items) {
        if (EventHooks.onPotionAttemptBrew(items)) {
            return;
        }
        ItemStack itemstack = (ItemStack)items.get(3);
        PotionBrewing potionbrewing = level.potionBrewing();
        for (int i = 0; i < 3; ++i) {
            items.set(i, (Object)potionbrewing.mix(itemstack, (ItemStack)items.get(i)));
        }
        EventHooks.onPotionBrewed(items);
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack itemstack1 = itemstack.getCraftingRemainingItem();
            itemstack.shrink(1);
            if (itemstack.isEmpty()) {
                itemstack = itemstack1;
            } else {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.shrink(1);
        }
        items.set(3, (Object)itemstack);
        level.levelEvent(1035, pos, 0);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.brewingItemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.brewingItemStacks, (HolderLookup.Provider)provider);
        this.brewTime = nbt.getShort("BrewTime");
    }

    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putShort("BrewTime", (short)this.brewTime);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.brewingItemStacks, (HolderLookup.Provider)provider);
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.brewingItemStacks;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> items) {
        this.brewingItemStacks = items;
    }

    @NotNull
    public ItemStack getItem(int index) {
        return index >= 0 && index < this.brewingItemStacks.size() ? (ItemStack)this.brewingItemStacks.get(index) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.brewingItemStacks, (int)index, (int)count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.brewingItemStacks, (int)index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(index, (Object)stack);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
        PotionBrewing potionbrewing;
        PotionBrewing potionBrewing = potionbrewing = this.level != null ? this.level.potionBrewing() : PotionBrewing.EMPTY;
        if (index == 3) {
            return potionbrewing.isIngredient(stack) && !stack.is(Tags.Items.DUSTS_REDSTONE) && !stack.is(Tags.Items.DUSTS_GLOWSTONE);
        }
        return potionbrewing.isInput(stack) && this.getItem(index).isEmpty();
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : OUTPUT_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (index == 3) {
            return stack.getItem() == Items.GLASS_BOTTLE;
        }
        return true;
    }

    public void clearContent() {
        this.brewingItemStacks.clear();
    }

    @NotNull
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return new WoodenBrewingStandContainer(id, player, (Container)this, this.dataAccess);
    }
}

