/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import elucent.eidolon.common.block.HorizontalBlockBase;
import elucent.eidolon.common.tile.NecroticFocusTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class NecroticFocusTileRenderer
implements BlockEntityRenderer<NecroticFocusTileEntity> {
    public void render(NecroticFocusTileEntity tileEntityIn, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer ir = mc.getItemRenderer();
        if (!tileEntityIn.stack.isEmpty()) {
            matrixStackIn.pushPose();
            Direction dir = (Direction)tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos()).getValue((Property)HorizontalBlockBase.HORIZONTAL_FACING);
            matrixStackIn.translate(0.5 + (double)dir.getStepX() * 0.25, 0.5 + (double)dir.getStepY() * 0.25, 0.5 + (double)dir.getStepZ() * 0.25);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(3.0f * ((float)(mc.level.getGameTime() % 360L) + partialTicks)));
            ir.renderStatic(tileEntityIn.stack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)mc.level, 0);
            matrixStackIn.popPose();
        }
    }
}

