/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.api.ritual.IRitualItemFocus;
import elucent.eidolon.common.tile.TileEntityBase;
import elucent.eidolon.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class NecroticFocusTileEntity
extends TileEntityBase
implements IRitualItemFocus {
    ItemStack stack = ItemStack.EMPTY;

    public NecroticFocusTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.NECROTIC_FOCUS_TILE_ENTITY.get(), pos, state);
    }

    public NecroticFocusTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        if (!this.stack.isEmpty()) {
            Containers.dropItemStack((Level)this.level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)this.stack);
        }
    }

    @Override
    public ItemInteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            if (player.getItemInHand(hand).isEmpty() && !this.stack.isEmpty()) {
                player.addItem(this.stack);
                this.stack = ItemStack.EMPTY;
                if (!this.level.isClientSide) {
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!player.getItemInHand(hand).isEmpty() && this.stack.isEmpty()) {
                this.stack = player.getItemInHand(hand).copy();
                this.stack.setCount(1);
                player.getItemInHand(hand).shrink(1);
                if (player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
                if (!this.level.isClientSide) {
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("stack"));
    }

    public void saveAdditional(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        tag.put("stack", this.stack.saveOptional(provider));
    }

    @Override
    public ItemStack provide() {
        return this.stack.copy();
    }

    @Override
    public void take() {
        this.stack = ItemStack.EMPTY;
        if (!this.level.isClientSide) {
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
    }

    @Override
    public void replace(ItemStack stack) {
        this.stack = stack;
        if (!this.level.isClientSide) {
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
    }
}

