/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.common.tile.TileEntityBase;
import elucent.eidolon.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EffigyTileEntity
extends TileEntityBase {
    long previous = -1L;

    public EffigyTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.EFFIGY_TILE_ENTITY.get(), pos, state);
    }

    public boolean ready() {
        return true;
    }

    public void pray() {
        if (!this.level.isClientSide) {
            this.previous = this.level.getGameTime();
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.previous = tag.getLong("previous");
    }

    public void saveAdditional(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        tag.putLong("previous", this.previous);
    }
}

