/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.common.tile.CrucibleTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class CrucibleTileRenderer
implements BlockEntityRenderer<CrucibleTileEntity> {
    private final ModelPart stirrer = Minecraft.getInstance().getEntityModels().bakeLayer(ClientRegistry.CRUCIBLE_STIRRER_LAYER).getChild("stirrer");
    public static final ResourceLocation STIRRER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"textures/block/crucible_stirrer.png");

    public static LayerDefinition createModelLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition stirrer = root.addOrReplaceChild("stirrer", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, 3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16);
    }

    public void render(CrucibleTileEntity tile, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float coeff;
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)STIRRER_TEXTURE);
        float f = coeff = tile.stirTicks == 0 ? 0.0f : ((float)tile.stirTicks - partialTicks) / 20.0f;
        if (!tile.getLevel().getBlockState(tile.getBlockPos().above()).isFaceSturdy((BlockGetter)tile.getLevel(), tile.getBlockPos().above(), Direction.DOWN)) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, 0.625, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(45.0f + coeff * 360.0f));
            matrixStackIn.translate(0.0, -0.125 * Math.sin((double)coeff * Math.PI), 0.125);
            this.stirrer.xRot = 0.3926991f * (1.0f - (float)Math.sin((double)coeff * Math.PI));
            this.stirrer.render(matrixStackIn, bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)STIRRER_TEXTURE)), combinedLightIn, combinedOverlayIn);
            matrixStackIn.popPose();
        }
        if (tile.hasWater) {
            TextureAtlasSprite water = (TextureAtlasSprite)mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/water_still"));
            VertexConsumer builder = bufferIn.getBuffer(RenderType.translucent());
            Matrix4f mat = matrixStackIn.last().pose();
            int color = BiomeColors.getAverageWaterColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos());
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            int a = FastColor.ARGB32.alpha((int)color);
            if (!tile.steps.isEmpty()) {
                r = (int)(tile.getRed() * 255.0f);
                g = (int)(tile.getGreen() * 255.0f);
                b = (int)(tile.getBlue() * 255.0f);
            }
            builder.addVertex(mat, 0.125f, 0.75f, 0.125f).setColor(r, g, b, 192).setUv(water.getU(2.0f), water.getV(2.0f)).setLight(combinedLightIn).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(mat, 0.125f, 0.75f, 0.875f).setColor(r, g, b, 192).setUv(water.getU(14.0f), water.getV(2.0f)).setLight(combinedLightIn).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(mat, 0.875f, 0.75f, 0.875f).setColor(r, g, b, 192).setUv(water.getU(14.0f), water.getV(14.0f)).setLight(combinedLightIn).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(mat, 0.875f, 0.75f, 0.125f).setColor(r, g, b, 192).setUv(water.getU(2.0f), water.getV(14.0f)).setLight(combinedLightIn).setNormal(0.0f, 1.0f, 0.0f);
        }
    }
}

