/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.tile.BrazierTileEntity;
import elucent.eidolon.event.ClientEvents;
import elucent.eidolon.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BrazierTileRenderer
implements BlockEntityRenderer<BrazierTileEntity> {
    public void render(BrazierTileEntity tileEntityIn, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer ir = mc.getItemRenderer();
        if (!tileEntityIn.getStack().isEmpty()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, 0.9375, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(3.0f * ((float)(mc.level.getGameTime() % 360L) + partialTicks)));
            ir.renderStatic(tileEntityIn.getStack(), ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)mc.level, 0);
            matrixStackIn.popPose();
        }
        if (tileEntityIn.ritual != null) {
            MultiBufferSource.BufferSource buffer = ClientEvents.getDelayedRender();
            Ritual ritual = tileEntityIn.ritual;
            float r = ritual.getRed();
            float g = ritual.getGreen();
            float b = ritual.getBlue();
            RenderUtil.dragon(matrixStackIn, (MultiBufferSource)buffer, 0.5, 3.0, 0.5, 1.0f, r, g, b);
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ritual.getSymbol());
            BlockPos pos = tileEntityIn.getBlockPos();
            RenderUtil.litBillboard(matrixStackIn, (MultiBufferSource)buffer, 0.5, 3.0, 0.5, r, g, b, sprite);
            RenderUtil.litBillboard(matrixStackIn, (MultiBufferSource)buffer, 0.5, 3.0, 0.5, r, g, b, sprite);
        }
    }
}

