/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.tile;

import elucent.eidolon.api.ritual.IRitualItemFocus;
import elucent.eidolon.api.ritual.IRitualItemProvider;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.block.SingleItemTile;
import elucent.eidolon.common.tile.IBurner;
import elucent.eidolon.network.ExtinguishEffectPacket;
import elucent.eidolon.network.FlameEffectPacket;
import elucent.eidolon.network.IgniteEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualCompletePacket;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.RitualRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class BrazierTileEntity
extends SingleItemTile
implements IBurner,
RecipeInput {
    boolean burning = false;
    int findingCounter = 0;
    int stepCounter = 0;
    Ritual ritual = null;
    int step = 0;
    boolean ritualDone = false;

    public BrazierTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.BRAZIER_TILE_ENTITY.get(), pos, state);
    }

    public BrazierTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        super.onDestroyed(state, pos);
        if (!this.stack.isEmpty() && this.level != null) {
            Containers.dropItemStack((Level)this.level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)this.stack);
        }
    }

    @Override
    public ItemInteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.level != null) {
            if (this.burning && player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty()) {
                this.extinguish();
                return ItemInteractionResult.SUCCESS;
            }
            if (!this.burning && player.getItemInHand(hand).isEmpty() && !this.stack.isEmpty()) {
                player.addItem(this.stack);
                this.stack = ItemStack.EMPTY;
                if (!this.level.isClientSide) {
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
                return ItemInteractionResult.SUCCESS;
            }
            boolean canBurn = this.canStartBurning();
            if (canBurn && player.getItemInHand(hand).getItem() instanceof FlintAndSteelItem) {
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                this.startBurning();
                return ItemInteractionResult.SUCCESS;
            }
            if (!player.getItemInHand(hand).isEmpty() && this.stack.isEmpty()) {
                this.stack = player.getItemInHand(hand).copy();
                this.stack.setCount(1);
                player.getItemInHand(hand).shrink(1);
                if (player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
                if (!this.level.isClientSide) {
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public boolean canStartBurning() {
        return !this.burning && !this.stack.isEmpty();
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.burning = tag.getBoolean("burning");
        this.step = tag.getInt("step");
        this.ritualDone = tag.getBoolean("ritualDone");
        if (this.burning && tag.contains("ritual")) {
            ResourceLocation rid = ResourceLocation.tryParse((String)tag.getString("ritual"));
            this.ritual = RitualRegistry.find(rid);
            if (this.ritual == null && this.level != null) {
                BrazierTileEntity.getRitualRecipes(this.level).stream().filter(r -> r.getId().equals((Object)rid)).findFirst().ifPresent(r -> {
                    this.ritual = r.getRitual();
                });
            }
        } else {
            this.ritual = null;
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("burning", this.burning);
        if (this.ritual != null) {
            tag.putString("ritual", this.ritual.getRegistryName().toString());
        }
        tag.putInt("step", this.step);
        tag.putBoolean("ritualDone", this.ritualDone);
    }

    protected void complete() {
        this.burning = false;
        this.stepCounter = 0;
        this.findingCounter = 0;
        if (this.level != null && !this.level.isClientSide) {
            if (this.ritual != null) {
                Networking.sendToNearbyClient(this.level, this.worldPosition.above(2), (CustomPacketPayload)new RitualCompletePacket(this.worldPosition.above(2), this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue()));
            }
            this.ritual = null;
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new ExtinguishEffectPacket(this.worldPosition));
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
        this.ritual = null;
    }

    @Override
    public void extinguish() {
        this.burning = false;
        this.stepCounter = 0;
        this.findingCounter = 0;
        if (this.level != null && !this.level.isClientSide) {
            if (this.ritual != null) {
                Networking.sendToNearbyClient(this.level, this.worldPosition.above(2), (CustomPacketPayload)new FlameEffectPacket(this.worldPosition.above(2), this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue()));
            }
            this.ritual = null;
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new ExtinguishEffectPacket(this.worldPosition));
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
        this.ritual = null;
    }

    @Override
    public void startBurning(Player player, @NotNull Level world, BlockPos pos) {
        this.startBurning();
    }

    public void startBurning() {
        this.burning = true;
        this.findingCounter = 0;
        if (this.level != null && !this.level.isClientSide) {
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new IgniteEffectPacket(this.worldPosition, 1.0f, 0.5f, 0.25f));
            this.sync((HolderLookup.Provider)this.level.registryAccess());
        }
    }

    protected void setRitual(Ritual ritual) {
        this.ritual = ritual;
        if (ritual == null) {
            this.extinguish();
        } else {
            this.stepCounter = 0;
            this.step = 0;
            this.ritualDone = false;
            if (this.level != null && !this.level.isClientSide) {
                Networking.sendToNearbyClient(this.level, this.worldPosition.above(2), (CustomPacketPayload)new FlameEffectPacket(this.worldPosition.above(2), ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
                this.sync((HolderLookup.Provider)this.level.registryAccess());
            }
        }
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        if (this.burning && this.findingCounter < 80 && this.ritual == null) {
            float progress = (float)(this.findingCounter - 40) / 40.0f;
            if (progress >= 0.0f) {
                for (int i = 0; i < 8; ++i) {
                    float angle = progress * (float)Math.PI / 4.0f + (float)i * (float)Math.PI / 4.0f;
                    float radius = 0.625f * Mth.sin((float)(4.0f * angle));
                    float x = (float)this.getBlockPos().getX() + 0.5f + Mth.sin((float)(angle += 0.7853982f)) * radius;
                    float y = (float)this.getBlockPos().getY() + 0.875f;
                    float z = (float)this.getBlockPos().getZ() + 0.5f + Mth.cos((float)angle) * radius;
                    Particles.create((ParticleType)EidolonParticles.WISP_PARTICLE.get()).setAlpha(0.25f * progress, 0.0f).setScale(0.125f, 0.0625f).setLifetime(20).setColor(1.0f, 0.5f, 0.25f, 1.0f, 0.25f, 0.375f).spawn(this.level, x, y, z);
                }
            }
            ++this.findingCounter;
            if (this.findingCounter == 80) {
                List<RitualRecipe> recipes = BrazierTileEntity.getRitualRecipes(this.level);
                recipes.stream().filter(recipe -> recipe.matches(this, this.level)).findFirst().ifPresentOrElse(recipe -> {
                    this.setRitual(recipe.getRitualWithRequirements());
                    this.stack = ItemStack.EMPTY;
                    this.findingCounter = 81;
                }, () -> {
                    this.ritualDone = true;
                    this.extinguish();
                });
            }
        }
        if (this.burning && this.ritual != null && !this.ritualDone) {
            ++this.stepCounter;
            if (this.stepCounter == 40) {
                Ritual.SetupResult result = this.ritual.setup(this.level, this.worldPosition, this.step);
                if (result == Ritual.SetupResult.SUCCEED) {
                    this.ritualDone = true;
                    if (!this.level.isClientSide) {
                        this.sync((HolderLookup.Provider)this.level.registryAccess());
                    }
                    if (this.ritual.start(this.level, this.worldPosition) == Ritual.RitualResult.TERMINATE) {
                        this.complete();
                    }
                } else if (result == Ritual.SetupResult.FAIL && !this.level.isClientSide) {
                    this.extinguish();
                } else if (!this.level.isClientSide) {
                    this.stepCounter = 0;
                    ++this.step;
                    this.sync((HolderLookup.Provider)this.level.registryAccess());
                }
            }
        }
        if (this.burning && this.ritual != null && this.ritualDone && this.ritual.tick(this.level, this.worldPosition) == Ritual.RitualResult.TERMINATE) {
            this.complete();
        }
        if (this.level.isClientSide && this.burning) {
            float x = (float)this.getBlockPos().getX() + 0.5f;
            float y = this.getBlockPos().getY() + 1;
            float z = (float)this.getBlockPos().getZ() + 0.5f;
            float r = this.ritual == null ? 1.0f : this.ritual.getRed();
            float g = this.ritual == null ? 0.5f : this.ritual.getGreen();
            float b = this.ritual == null ? 0.25f : this.ritual.getBlue();
            Particles.create((ParticleType)EidolonParticles.FLAME_PARTICLE.get()).setAlpha(0.5f, 0.0f).setScale(0.3125f, 0.125f).setLifetime(20).randomOffset(0.25, 0.125).randomVelocity(0.00625f, 0.01875f).addVelocity(0.0, 0.00625f, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).spawn(this.level, x, y, z);
            if (this.level.random.nextInt(5) == 0) {
                Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).setAlpha(0.125f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset(0.25, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.1f, 0.0).setColor(0.5f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f).spawn(this.level, x, (double)y + 0.125, z);
            }
            if (this.level.random.nextInt(40) == 0) {
                Particles.create((ParticleType)EidolonParticles.SPARKLE_PARTICLE.get()).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(40).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.0).addVelocity(0.0, 0.125, 0.0).setColor(r, g * 1.5f, b * 2.0f, r, g, b).enableGravity().setSpin(0.4f).spawn(this.level, x, y, z);
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.worldPosition.getX() - 1), (double)this.worldPosition.getY(), (double)(this.worldPosition.getZ() - 1), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 4), (double)(this.worldPosition.getZ() + 1));
    }

    public void providePedestalItems(List<ItemStack> pedestalItems, List<ItemStack> focusItems) {
        Ritual.getTilesWithinAABB(IRitualItemProvider.class, this.level, Ritual.getDefaultBounds(this.worldPosition)).forEach(tile -> {
            if (tile instanceof IRitualItemFocus) {
                IRitualItemFocus provider = (IRitualItemFocus)tile;
                focusItems.add(provider.provide());
            } else {
                pedestalItems.add(tile.provide());
            }
        });
        focusItems.removeIf(ItemStack::isEmpty);
        pedestalItems.removeIf(ItemStack::isEmpty);
    }

    public static List<RitualRecipe> getRitualRecipes(Level world) {
        ArrayList<RitualRecipe> recipes = new ArrayList<RitualRecipe>();
        RecipeManager manager = world.getRecipeManager();
        for (RecipeType<? extends RitualRecipe> type : EidolonRecipes.ritualRecipeTypes) {
            recipes.addAll(manager.getAllRecipesFor(type).stream().map(RecipeHolder::value).toList());
        }
        return recipes;
    }

    public int size() {
        return 1;
    }
}

