/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.capability.IMana;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.common.spell.StaticSpell;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class WaterSpell
extends StaticSpell {
    public WaterSpell(ResourceLocation name, Sign ... signs) {
        super(name, 10, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        HitResult ray = WaterSpell.rayTrace((Entity)player, player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue(), 0.0f, true);
        if (world.dimensionType().ultraWarm() || world.isClientSide()) {
            return;
        }
        if (ray instanceof BlockHitResult) {
            LiquidBlockContainer liquidBlockContainer;
            BlockHitResult rayTraceResult = (BlockHitResult)ray;
            BlockPos pos1 = rayTraceResult.getBlockPos();
            BlockState hitState = world.getBlockState(pos1);
            BlockEntity blockEntity = world.getBlockEntity(pos1);
            Block block = hitState.getBlock();
            if (block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)world, pos1, world.getBlockState(pos1), (Fluid)Fluids.WATER)) {
                liquidBlockContainer.placeLiquid((LevelAccessor)world, pos1, hitState, Fluids.WATER.getSource(true));
            } else {
                IFluidHandler fluidHandler = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, rayTraceResult.getBlockPos(), (Object)rayTraceResult.getDirection());
                if (fluidHandler != null) {
                    fluidHandler.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                } else if (world.getBlockState(pos1.relative(rayTraceResult.getDirection())).canBeReplaced((Fluid)Fluids.WATER)) {
                    pos1 = pos1.relative(rayTraceResult.getDirection());
                    world.setBlockAndUpdate(pos1, Blocks.WATER.defaultBlockState());
                }
                IMana.expendMana(player, this.getCost());
            }
        }
    }
}

