/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.SignSequence;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.capability.PatronManaImpl;
import elucent.eidolon.registries.EidolonCapabilities;
import elucent.eidolon.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StaticSpell
extends Spell {
    public SignSequence signs;
    private int cost;
    private int delay = 10;
    @Nullable
    public ModConfigSpec.ConfigValue<Integer> COST;

    public StaticSpell(ResourceLocation name, Sign ... signs) {
        super(name);
    }

    @Override
    public void setSigns(SignSequence signs) {
        this.signs = signs;
    }

    public StaticSpell(ResourceLocation name, int cost, Sign ... signs) {
        this(name, signs);
        this.cost = cost;
    }

    public StaticSpell(ResourceLocation name, int cost, int delay, Sign ... signs) {
        this(name, signs);
        this.cost = cost;
        this.delay = delay;
    }

    @Override
    public int getCost() {
        return this.COST == null ? this.cost : (Integer)this.COST.get();
    }

    @NotNull
    protected static Vec3 getVector(Level world, Player player) {
        BlockHitResult ray = world.clip(new ClipContext(player.getEyePosition(0.0f), player.getEyePosition(0.0f).add(player.getLookAngle().scale(4.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        return ray.getType() == HitResult.Type.BLOCK ? ray.getLocation() : player.getEyePosition(0.0f).add(player.getLookAngle().scale(4.0));
    }

    public static HitResult rayTrace(Entity entity, double length, float lookOffset, boolean hitLiquids) {
        HitResult result = entity.pick(length, lookOffset, hitLiquids);
        EntityHitResult entityLookedAt = MathUtil.getLookedAtEntity(entity, 25);
        return entityLookedAt == null ? result : entityLookedAt;
    }

    @Override
    public boolean matches(SignSequence signs) {
        return this.signs.equals(signs);
    }

    public abstract boolean canCast(Level var1, BlockPos var2, Player var3);

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player, SignSequence signs) {
        PatronManaImpl mana;
        if (this.getCost() > 0 && !player.isCreative() && (mana = (PatronManaImpl)player.getCapability(EidolonCapabilities.MANA_CAPABILITY)) != null && mana.getMagic() < (float)this.getCost()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"eidolon.title.no_mana")));
            }
            return false;
        }
        return this.canCast(world, pos, player);
    }

    public abstract void cast(Level var1, BlockPos var2, Player var3);

    @Override
    public void cast(Level world, BlockPos pos, Player player, SignSequence signs) {
        this.cast(world, pos, player);
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder spellBuilder) {
        this.DELAY = spellBuilder.comment("The delay in ticks before the spell is cast").defineInRange("delay", this.delay, 0, Integer.MAX_VALUE);
        this.COST = spellBuilder.comment("The cost of casting this spell").defineInRange("cost", this.cost, 0, Integer.MAX_VALUE);
    }
}

