/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class SmiteSpell
extends StaticSpell {
    @Nullable
    public ModConfigSpec.DoubleValue DAMAGE;

    public SmiteSpell(ResourceLocation name, Sign ... signs) {
        super(name, 40, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        EntityHitResult entityHitResult;
        Entity entity;
        HitResult ray = SmiteSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (ray instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)ray).getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.getType().is(EntityTypeTags.UNDEAD);
        }
        return false;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        LivingEntity livingEntity;
        EntityHitResult entityHitResult;
        Entity entity;
        HitResult ray = SmiteSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (ray instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)ray).getEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getType().is(EntityTypeTags.UNDEAD) && world instanceof ServerLevel && livingEntity.hurt(livingEntity.damageSources().magic(), this.DAMAGE == null ? 10.0f : ((Double)this.DAMAGE.get()).floatValue())) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 2));
            KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.SMITE_UNDEAD);
        }
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder spellBuilder) {
        super.buildConfig(spellBuilder);
        this.DAMAGE = spellBuilder.comment("The amount of damage dealt by the spell").defineInRange("damage", 10.0, 1.0, 2.147483647E9);
    }
}

