/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.capability.IMana;
import elucent.eidolon.api.capability.IReputation;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.registries.EidolonCapabilities;
import elucent.eidolon.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.ModConfigSpec;

public class HealSpell
extends StaticSpell {
    ModConfigSpec.IntValue BASE_HEAL;
    ModConfigSpec.IntValue REP_FROM_HEAL;
    ModConfigSpec.DoubleValue DEVOTION_TO_HEAL;

    public HealSpell(ResourceLocation name, Sign ... signs) {
        super(name, 15, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        if (!world.isClientSide) {
            Player toHeal;
            LivingEntity living;
            EntityHitResult entityHitResult;
            Entity entity;
            float heal = this.getBaseHealing();
            IReputation cap = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
            if (cap == null) {
                return;
            }
            double devotion = cap.getReputation(Deities.LIGHT_DEITY.getId());
            heal += (float)(devotion * this.getDevotionToHeal());
            HitResult ray = HealSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), 0.0f, false);
            boolean other = false;
            if (ray instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)ray).getEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).getType().is(EntityTypeTags.UNDEAD)) {
                toHeal = living;
                other = living.getHealth() < living.getMaxHealth();
            } else {
                toHeal = player;
            }
            toHeal.heal(heal);
            for (MobEffectInstance effectInstance : toHeal.getActiveEffects()) {
                Holder effect = effectInstance.getEffect();
                if (((MobEffect)effect.value()).isBeneficial() || !effectInstance.getCures().contains(EffectCures.MILK)) continue;
                toHeal.removeEffect(effect);
            }
            if (other) {
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.HEAL_VILLAGER);
                cap.addReputation(Deities.LIGHT_DEITY.getId(), this.getRepFromHealOther());
            }
            IMana.expendMana(player, this.getCost());
        }
    }

    public int getBaseHealing() {
        return this.BASE_HEAL == null ? 5 : (Integer)this.BASE_HEAL.get();
    }

    public double getDevotionToHeal() {
        return this.DEVOTION_TO_HEAL == null ? 0.05 : (Double)this.DEVOTION_TO_HEAL.get();
    }

    public int getRepFromHealOther() {
        return this.REP_FROM_HEAL == null ? 3 : (Integer)this.REP_FROM_HEAL.get();
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder spellBuilder) {
        super.buildConfig(spellBuilder);
        this.BASE_HEAL = spellBuilder.comment("Base healing amount").defineInRange("base_heal", 5, 1, 100);
        this.REP_FROM_HEAL = spellBuilder.comment("Reputation gained from healing other entities").defineInRange("rep_from_heal", 3, 1, 100);
        this.DEVOTION_TO_HEAL = spellBuilder.comment("Devotion to extra healing ratio").defineInRange("devotion_to_heal", 0.05, 0.0, 1.0);
    }
}

