/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.entity.ai.GoToPositionGoal;
import elucent.eidolon.util.ColorUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RepellingRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"particle/repelling_ritual");

    public RepellingRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 190, 212, 184));
    }

    @Override
    public Ritual cloneRitual() {
        return new RepellingRitual();
    }

    @Override
    public Ritual.RitualResult tick(Level world, BlockPos pos) {
        if (world.getGameTime() % 200L == 0L) {
            List monsters = world.getEntitiesOfClass(Monster.class, new AABB(pos).inflate(96.0, 16.0, 96.0));
            for (Monster a : monsters) {
                boolean hasGoal;
                List goals = a.goalSelector.getAvailableGoals().stream().filter(goal -> goal.isRunning() && goal.getGoal() instanceof GoToPositionGoal).collect(Collectors.toList());
                boolean bl = hasGoal = !goals.isEmpty();
                if (!hasGoal && a.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= 6400.0) {
                    BlockPos diff = a.blockPosition().subtract((Vec3i)pos);
                    Vec3 diffv = new Vec3((double)diff.getX(), 0.0, (double)diff.getZ());
                    diffv = diffv.scale(90.0 / diffv.length());
                    int i = pos.getX() + (int)diffv.x;
                    int j = pos.getZ() + (int)diffv.z;
                    BlockPos target = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, new BlockPos(i, 0, j));
                    a.goalSelector.addGoal(1, (Goal)new GoToPositionGoal((PathfinderMob)a, target, 1.0));
                    continue;
                }
                if (!hasGoal || !(a.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > 7744.0)) continue;
                for (Goal g : goals) {
                    a.goalSelector.removeGoal(g);
                }
            }
        }
        return Ritual.RitualResult.PASS;
    }
}

