/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.util.EidolonFakePlayer;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;

public class ExecCommandRitual
extends Ritual {
    List<String> commands;

    public List<String> getCommands() {
        return this.commands;
    }

    public ExecCommandRitual(ResourceLocation symbol, int color, List<String> command) {
        super(symbol, color);
        this.commands = command;
    }

    @Override
    public Ritual cloneRitual() {
        return new ExecCommandRitual(this.getSymbol(), this.getColor(), this.getCommands());
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            MinecraftServer server = world.getServer();
            for (String command : this.commands) {
                if (!server.isCommandBlockEnabled() || StringUtil.isNullOrEmpty((String)command)) continue;
                try {
                    EidolonFakePlayer fakePlayer = EidolonFakePlayer.getPlayer(serverWorld);
                    fakePlayer.setPos(pos.getCenter());
                    CommandSourceStack commandSource = fakePlayer.createCommandSourceStack().withPermission(2).withSuppressedOutput();
                    server.getCommands().performPrefixedCommand(commandSource, command);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Executing command ritual");
                    CrashReportCategory crashreportcategory = crashreport.addCategory("Command to be executed");
                    crashreportcategory.setDetail("Command", (Object)command);
                    throw new ReportedException(crashreport);
                }
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

