/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.PrimaryLevelData;

public class DaylightRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"particle/daylight_ritual");

    public DaylightRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 255, 245, 130));
    }

    @Override
    public Ritual cloneRitual() {
        return new DaylightRitual();
    }

    @Override
    public Ritual.RitualResult tick(Level world, BlockPos pos) {
        if (world.getDayTime() % 24000L < 1000L || world.getDayTime() % 24000L >= 12000L) {
            if (!world.isClientSide) {
                ((PrimaryLevelData)world.getLevelData()).setDayTime(world.getDayTime() + 100L);
                for (ServerPlayer player : ((ServerLevel)world).players()) {
                    player.connection.send((Packet)new ClientboundSetTimePacket(world.getGameTime(), world.getDayTime(), world.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
                }
            }
            return Ritual.RitualResult.PASS;
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

