/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.network.CrystallizeEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.util.ColorUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class CrystalRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"particle/crystal_ritual");

    public CrystalRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 247, 156, 220));
    }

    @Override
    public Ritual cloneRitual() {
        return new CrystalRitual();
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        List entities = world.getEntitiesOfClass(LivingEntity.class, this.getSearchBounds(pos), LivingEntity::isInvertedHealAndHarm);
        for (LivingEntity e : entities) {
            e.hurt(Registry.RITUAL_DAMAGE.source((LevelAccessor)world), e.getMaxHealth() * 1000.0f);
            if (world.isClientSide) continue;
            Networking.sendToNearbyClient(world, e.blockPosition(), (CustomPacketPayload)new CrystallizeEffectPacket(e.blockPosition()));
            world.addFreshEntity((Entity)new ItemEntity(world, e.getX(), e.getY(), e.getZ(), new ItemStack((ItemLike)Registry.SOUL_SHARD.get(), 1 + world.random.nextInt(3))));
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

