/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.tile.BrazierTileEntity;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CraftingRitual
extends Ritual {
    final ItemStack result;
    private final boolean keepNbtOfReagent;

    public CraftingRitual(ResourceLocation symbol, int color, ItemStack result) {
        this(symbol, color, result, true);
    }

    public CraftingRitual(ResourceLocation symbol, int color, ItemStack result, boolean keepNBT) {
        super(symbol, color);
        this.result = result;
        this.keepNbtOfReagent = keepNBT;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"eidolon.ritual.crafting", (Object[])new Object[]{this.result.getDisplayName().getString()});
    }

    @Override
    public Ritual cloneRitual() {
        return new CraftingRitual(this.getSymbol(), this.getColor(), this.result);
    }

    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof BrazierTileEntity) {
            BrazierTileEntity inv = (BrazierTileEntity)blockEntity;
            ItemStack result = this.getResult().copy();
            if (this.keepNbtOfReagent && !inv.getStack().isComponentsPatchEmpty()) {
                result.applyComponents(inv.getStack().getComponentsPatch());
                result.setDamageValue(0);
            }
            world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 2.5, (double)pos.getZ() + 0.5, result));
        }
        return Ritual.RitualResult.TERMINATE;
    }

    public static class SanguineRitual
    extends CraftingRitual {
        public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon", (String)"particle/sanguine_ritual");

        public SanguineRitual(ItemStack result) {
            super(SYMBOL, ColorUtil.packColor(255, 255, 51, 85), result);
        }
    }
}

