/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public abstract class ArmorModel
extends HumanoidModel<LivingEntity> {
    public EquipmentSlot slot;
    final ModelPart root;
    final ModelPart head;
    final ModelPart body;
    final ModelPart leftArm;
    final ModelPart rightArm;
    final ModelPart pelvis;
    final ModelPart leftLegging;
    final ModelPart rightLegging;
    final ModelPart leftFoot;
    final ModelPart rightFoot;

    public ArmorModel(ModelPart root) {
        super(root);
        this.root = root;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.pelvis = root.getChild("pelvis");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
        this.leftLegging = root.getChild("left_legging");
        this.rightLegging = root.getChild("right_legging");
        this.leftFoot = root.getChild("left_foot");
        this.rightFoot = root.getChild("right_foot");
    }

    public static PartDefinition createHumanoidAlias(MeshDefinition mesh) {
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("pelvis", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("head", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("left_legging", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("left_foot", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("right_legging", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("right_foot", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("left_arm", new CubeListBuilder(), PartPose.ZERO);
        root.addOrReplaceChild("right_arm", new CubeListBuilder(), PartPose.ZERO);
        return root;
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return this.slot == EquipmentSlot.HEAD ? ImmutableList.of((Object)this.head) : ImmutableList.of();
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.leftLegging, (Object)this.rightLegging, (Object)this.pelvis);
        }
        if (this.slot == EquipmentSlot.FEET) {
            return ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot);
        }
        return ImmutableList.of();
    }

    public void copyFromDefault(HumanoidModel<?> model) {
        this.body.copyFrom(model.body);
        this.pelvis.copyFrom(this.body);
        this.leftLegging.copyFrom(this.leftLeg);
        this.rightLegging.copyFrom(this.rightLeg);
        this.leftFoot.copyFrom(this.leftLeg);
        this.rightFoot.copyFrom(this.rightLeg);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

