/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.common.item.curio.EidolonCurio;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.registries.Registry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class VoidAmuletItem
extends EidolonCurio {
    public VoidAmuletItem(Item.Properties properties) {
        super(properties.component(EidolonDataComponents.COOLDOWN, (Object)0));
        NeoForge.EVENT_BUS.addListener(VoidAmuletItem::onDamage);
    }

    static int getCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault(EidolonDataComponents.COOLDOWN, (Object)0);
    }

    static void setCooldown(ItemStack stack, int cooldown) {
        stack.set(EidolonDataComponents.COOLDOWN, (Object)cooldown);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!slotContext.entity().level().isClientSide && VoidAmuletItem.getCooldown(stack) > 0) {
            VoidAmuletItem.setCooldown(stack, VoidAmuletItem.getCooldown(stack) - 1);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(inventory -> inventory.findFirstCurio((Item)Registry.VOID_AMULET.get())).ifPresent(slots -> {
                ItemStack stack = slots.stack();
                if (VoidAmuletItem.getCooldown(stack) == 0 && (event.getSource().getDirectEntity() instanceof Projectile || event.getSource().getDirectEntity() instanceof SpellProjectileEntity)) {
                    event.setCanceled(true);
                    if (!event.getEntity().getCommandSenderWorld().isClientSide) {
                        event.getEntity().getCommandSenderWorld().playSound(null, event.getEntity().blockPosition(), SoundEvents.WITHER_HURT, SoundSource.PLAYERS, 1.0f, 0.75f);
                    }
                    VoidAmuletItem.setCooldown(stack, 100);
                }
            });
        }
    }
}

