/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import com.mojang.datafixers.util.Either;
import elucent.eidolon.common.item.ChantScrollItem;
import elucent.eidolon.common.item.curio.EidolonCurio;
import elucent.eidolon.registries.EidolonDataComponents;
import elucent.eidolon.registries.Registry;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class SanguineAmuletItem
extends EidolonCurio {
    public SanguineAmuletItem(Item.Properties properties) {
        super(properties);
    }

    static int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault(EidolonDataComponents.SANGUINE_CHARGES, (Object)0);
    }

    static void addCharge(ItemStack stack, int diff) {
        int newCharge = Mth.clamp((int)(SanguineAmuletItem.getCharge(stack) + diff), (int)0, (int)40);
        stack.set(EidolonDataComponents.SANGUINE_CHARGES, (Object)newCharge);
    }

    static void setCharge(ItemStack stack, int charge) {
        int newCharge = Mth.clamp((int)charge, (int)0, (int)40);
        stack.set(EidolonDataComponents.SANGUINE_CHARGES, (Object)newCharge);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (!entity.level().isClientSide) {
            Player player;
            if (entity.tickCount % 80 == 0 && (double)entity.getHealth() >= (double)entity.getMaxHealth() - 1.0E-4 && entity instanceof Player && (player = (Player)entity).getFoodData().getFoodLevel() >= 18 && SanguineAmuletItem.getCharge(stack) < 40) {
                float f = player.getFoodData().getSaturationLevel() > 0.0f ? Math.min(4.0f * player.getFoodData().getSaturationLevel(), 16.0f) : 4.0f;
                player.causeFoodExhaustion(f);
                SanguineAmuletItem.addCharge(stack, 1);
            }
            if (entity.tickCount % 10 == 0 && SanguineAmuletItem.getCharge(stack) > 0 && entity.getHealth() < entity.getMaxHealth()) {
                int taken = (int)Math.min(1.0f, entity.getMaxHealth() - entity.getHealth());
                SanguineAmuletItem.addCharge(stack, -taken);
                entity.heal((float)taken);
            }
        }
    }

    public boolean canSync(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @NotNull
    public CompoundTag writeSyncData(SlotContext slotContext, ItemStack stack) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("charge", SanguineAmuletItem.getCharge(stack));
        return nbt;
    }

    public void readSyncData(SlotContext slotContext, CompoundTag compound, ItemStack stack) {
        SanguineAmuletItem.setCharge(stack, compound.getInt("charge"));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() == Registry.SANGUINE_AMULET.get()) {
            event.getTooltipElements().add(Either.right((Object)new SanguineAmuletTooltipInfo(stack, event.getMaxWidth())));
        } else if (stack.getItem() == Registry.CHANT_SCROLL.get()) {
            event.getTooltipElements().add(Either.right((Object)new ChantScrollItem.ChantTooltipInfo(stack, event.getMaxWidth())));
        }
    }

    public record SanguineAmuletTooltipInfo(ItemStack stack, int maxWidth) implements TooltipComponent
    {
    }

    public static class SanguineAmuletTooltipComponent
    implements ClientTooltipComponent {
        final ItemStack stack;
        final int maxWidth;

        public SanguineAmuletTooltipComponent(SanguineAmuletTooltipInfo info) {
            this.stack = info.stack;
            this.maxWidth = info.maxWidth;
        }

        public int getHeight() {
            int charge = SanguineAmuletItem.getCharge(this.stack);
            int rows = (charge + 19) / 20;
            return 8 + 12 * rows;
        }

        public int getWidth(@NotNull Font font) {
            return this.maxWidth;
        }

        public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics pGuiGraphics) {
            int charge = SanguineAmuletItem.getCharge(this.stack);
            for (int i = 0; i < charge; i += 20) {
                for (int j = 0; j < Mth.clamp((int)(charge - i), (int)0, (int)20); j += 2) {
                    if (charge - (i + j) == 1) {
                        pGuiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/icons.png"), x - 1 + j / 2 * 8, y + i / 20 * 9 + 2, 61.0f, 0.0f, 9, 9, 256, 256);
                        continue;
                    }
                    pGuiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/icons.png"), x - 1 + j / 2 * 8, y + i / 20 * 9 + 2, 52.0f, 0.0f, 9, 9, 256, 256);
                }
            }
        }
    }
}

